/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.defaultimpl;

import com.google.common.collect.Lists;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.servlet.GuiceServletContextListener;
import com.google.inject.servlet.ServletModule;
import com.netflix.priam.PriamServer;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.defaultimpl.PriamGuiceModule;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletContextEvent;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectedWebListener
extends GuiceServletContextListener {
    protected static final Logger logger = LoggerFactory.getLogger(InjectedWebListener.class);
    private Injector injector;

    protected Injector getInjector() {
        ArrayList moduleList = Lists.newArrayList();
        moduleList.add(new JaxServletModule());
        moduleList.add(new PriamGuiceModule());
        this.injector = Guice.createInjector((Iterable)moduleList);
        try {
            ((IConfiguration)this.injector.getInstance(IConfiguration.class)).intialize();
            ((PriamServer)this.injector.getInstance(PriamServer.class)).initialize();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        return this.injector;
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        try {
            for (Scheduler scheduler : ((SchedulerFactory)this.injector.getInstance(SchedulerFactory.class)).getAllSchedulers()) {
                scheduler.shutdown();
            }
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
        super.contextDestroyed(servletContextEvent);
    }

    public static class JaxServletModule
    extends ServletModule {
        protected void configureServlets() {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("com.sun.jersey.config.property.packages", "unbound");
            params.put("com.sun.jersey.config.property.packages", "com.netflix.priam.resources");
            params.put("com.sun.jersey.config.feature.FilterContextPath", "/REST");
            this.serve("/REST/*", new String[0]).with(GuiceContainer.class, params);
        }
    }
}

