/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.merics;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Registry;

@Singleton
public class BackupMetrics {
    private final DistributionSummary uploadRate;
    private final Counter validUploads;
    private final Counter invalidUploads;
    private final Counter validDownloads;
    private final Counter invalidDownloads;
    private final Counter awsSlowDownException;
    private final Counter snsNotificationSuccess;
    private final Counter snsNotificationFailure;

    @Inject
    public BackupMetrics(Registry registry) {
        this.validDownloads = registry.counter("priam.download.valid");
        this.invalidDownloads = registry.counter("priam.download.invalid");
        this.validUploads = registry.counter("priam.upload.valid");
        this.invalidUploads = registry.counter("priam.upload.invalid");
        this.uploadRate = registry.distributionSummary("priam.upload.rate");
        this.awsSlowDownException = registry.counter("priam.aws.slowDown");
        this.snsNotificationSuccess = registry.counter("priam.sns.notification.success");
        this.snsNotificationFailure = registry.counter("priam.sns.notification.failure");
    }

    public void incrementValidUploads() {
        this.validUploads.increment();
    }

    public void incrementInvalidUploads() {
        this.invalidUploads.increment();
    }

    public long getValidUploads() {
        return this.validUploads.count();
    }

    public long getValidDownloads() {
        return this.validDownloads.count();
    }

    public void incrementValidDownloads() {
        this.invalidDownloads.increment();
    }

    public void incrementInvalidDownloads() {
        this.invalidDownloads.increment();
    }

    public long getAwsSlowDownException() {
        return this.awsSlowDownException.count();
    }

    public void incrementAwsSlowDownException(int awsSlowDown) {
        this.awsSlowDownException.increment((long)awsSlowDown);
    }

    public void incrementSnsNotificationSuccess() {
        this.snsNotificationSuccess.increment();
    }

    public void incrementSnsNotificationFailure() {
        this.snsNotificationFailure.increment();
    }

    public void recordUploadRate(long sizeInBytes) {
        this.uploadRate.record(sizeInBytes);
    }
}

