/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.resources;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.netflix.priam.PriamServer;
import com.netflix.priam.backup.AbstractBackupPath;
import com.netflix.priam.backup.BackupMetadata;
import com.netflix.priam.backup.BackupVerification;
import com.netflix.priam.backup.BackupVerificationResult;
import com.netflix.priam.backup.IBackupFileSystem;
import com.netflix.priam.backup.IBackupStatusMgr;
import com.netflix.priam.backup.IncrementalBackup;
import com.netflix.priam.backup.MetaData;
import com.netflix.priam.backup.SnapshotBackup;
import com.netflix.priam.backup.Status;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.defaultimpl.ICassandraProcess;
import com.netflix.priam.identity.IPriamInstanceFactory;
import com.netflix.priam.identity.PriamInstance;
import com.netflix.priam.restore.Restore;
import com.netflix.priam.scheduler.PriamScheduler;
import com.netflix.priam.tuner.ICassandraTuner;
import com.netflix.priam.utils.CassandraMonitor;
import com.netflix.priam.utils.DateUtil;
import com.netflix.priam.utils.ITokenManager;
import com.netflix.priam.utils.SystemUtils;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/backup")
@Produces(value={"application/json"})
public class BackupServlet {
    private static final Logger logger = LoggerFactory.getLogger(BackupServlet.class);
    private static final String REST_SUCCESS = "[\"ok\"]";
    private static final String REST_HEADER_RANGE = "daterange";
    private static final String REST_HEADER_FILTER = "filter";
    private static final String REST_HEADER_TOKEN = "token";
    private static final String REST_HEADER_REGION = "region";
    private static final String REST_KEYSPACES = "keyspaces";
    private static final String REST_RESTORE_PREFIX = "restoreprefix";
    private static final String FMT = "yyyyMMddHHmm";
    private static final String REST_LOCR_ROWKEY = "verifyrowkey";
    private static final String REST_LOCR_KEYSPACE = "verifyks";
    private static final String REST_LOCR_COLUMNFAMILY = "verifycf";
    private static final String REST_LOCR_FILEEXTENSION = "verifyfileextension";
    private static final String SSTABLE2JSON_DIR_LOCATION = "/tmp/priam_sstables";
    private static final String SSTABLE2JSON_COMMAND_FROM_CASSHOME = "/bin/sstable2json";
    private PriamServer priamServer;
    private IConfiguration config;
    private IBackupFileSystem backupFs;
    private IBackupFileSystem bkpStatusFs;
    private Restore restoreObj;
    private Provider<AbstractBackupPath> pathProvider;
    private ICassandraTuner tuner;
    private SnapshotBackup snapshotBackup;
    private IPriamInstanceFactory factory;
    private final ITokenManager tokenManager;
    private final ICassandraProcess cassProcess;
    private BackupVerification backupVerification;
    @Inject
    private PriamScheduler scheduler;
    @Inject
    private MetaData metaData;
    private IBackupStatusMgr completedBkups;

    @Inject
    public BackupServlet(PriamServer priamServer, IConfiguration config, @Named(value="backup") IBackupFileSystem backupFs, @Named(value="backup_status") IBackupFileSystem bkpStatusFs, Restore restoreObj, Provider<AbstractBackupPath> pathProvider, ICassandraTuner tuner, SnapshotBackup snapshotBackup, IPriamInstanceFactory factory, ITokenManager tokenManager, ICassandraProcess cassProcess, IBackupStatusMgr completedBkups, BackupVerification backupVerification) {
        this.priamServer = priamServer;
        this.config = config;
        this.backupFs = backupFs;
        this.bkpStatusFs = bkpStatusFs;
        this.restoreObj = restoreObj;
        this.pathProvider = pathProvider;
        this.tuner = tuner;
        this.snapshotBackup = snapshotBackup;
        this.factory = factory;
        this.tokenManager = tokenManager;
        this.cassProcess = cassProcess;
        this.completedBkups = completedBkups;
        this.backupVerification = backupVerification;
    }

    @GET
    @Path(value="/do_snapshot")
    public Response backup() throws Exception {
        this.snapshotBackup.execute();
        return Response.ok((Object)REST_SUCCESS, (String)"application/json").build();
    }

    @GET
    @Path(value="/incremental_backup")
    public Response backupIncrementals() throws Exception {
        this.scheduler.addTask("IncrementalBackup", IncrementalBackup.class, IncrementalBackup.getTimer());
        return Response.ok((Object)REST_SUCCESS, (String)"application/json").build();
    }

    @GET
    @Path(value="/list")
    public Response list(@QueryParam(value="daterange") String daterange, @QueryParam(value="filter") @DefaultValue(value="") String filter) throws Exception {
        Date endTime;
        Date startTime;
        if (StringUtils.isBlank((CharSequence)daterange) || daterange.equalsIgnoreCase("default")) {
            startTime = new DateTime().minusDays(1).toDate();
            endTime = new DateTime().toDate();
        } else {
            String[] restore = daterange.split(",");
            AbstractBackupPath path = (AbstractBackupPath)this.pathProvider.get();
            startTime = path.parseDate(restore[0]);
            endTime = path.parseDate(restore[1]);
        }
        logger.info("Parameters: {backupPrefix: [{}], daterange: [{}], filter: [{}]}", new Object[]{this.config.getBackupPrefix(), daterange, filter});
        Iterator<AbstractBackupPath> it = this.bkpStatusFs.list(this.config.getBackupPrefix(), startTime, endTime);
        JSONObject object = new JSONObject();
        object = this.constructJsonResponse(object, it, filter);
        return Response.ok((Object)object.toString(2), (String)"application/json").build();
    }

    @GET
    @Path(value="/status")
    @Produces(value={"application/json"})
    public Response status() throws Exception {
        int restoreTCount = this.restoreObj.getActiveCount();
        logger.debug("Thread counts for restore is: {}", (Object)restoreTCount);
        int backupTCount = this.backupFs.getActivecount();
        logger.debug("Thread counts for snapshot backup is: {}", (Object)backupTCount);
        JSONObject object = new JSONObject();
        object.put("ThreadCount", (Object)new Integer(backupTCount));
        object.put("SnapshotStatus", (Object)this.snapshotBackup.state().toString());
        return Response.ok((Object)object.toString(), (String)"application/json").build();
    }

    @GET
    @Path(value="/status/{date}")
    @Produces(value={"application/json"})
    public Response statusByDate(@PathParam(value="date") String date) throws Exception {
        JSONObject object = new JSONObject();
        List<BackupMetadata> metadataLinkedList = this.completedBkups.locate(date);
        if (metadataLinkedList != null && !metadataLinkedList.isEmpty()) {
            BackupMetadata bkupMetadata = metadataLinkedList.get(0);
            object.put("Snapshotstatus", bkupMetadata.getStatus().equals((Object)Status.FINISHED));
            String token = bkupMetadata.getToken();
            if (token != null && !token.isEmpty()) {
                object.put(REST_HEADER_TOKEN, (Object)bkupMetadata.getToken());
            } else {
                object.put(REST_HEADER_TOKEN, (Object)"not available");
            }
            if (bkupMetadata.getStart() != null) {
                object.put("starttime", (Object)DateUtil.formatyyyyMMddHHmm(bkupMetadata.getStart()));
            } else {
                object.put("starttime", (Object)"not available");
            }
            if (bkupMetadata.getCompleted() != null) {
                object.put("completetime", (Object)DateUtil.formatyyyyMMddHHmm(bkupMetadata.getCompleted()));
            } else {
                object.put("completetime", (Object)"not_available");
            }
        } else {
            object.put("Snapshotstatus", false);
            String token = SystemUtils.getDataFromUrl("http://localhost:8080/Priam/REST/v1/cassconfig/get_token");
            if (token != null && !token.isEmpty()) {
                object.put(REST_HEADER_TOKEN, (Object)token);
            } else {
                object.put(REST_HEADER_TOKEN, (Object)"not available");
            }
        }
        return Response.ok((Object)object.toString(), (String)"application/json").build();
    }

    @GET
    @Path(value="/status/{date}/snapshots")
    @Produces(value={"application/json"})
    public Response snapshotsByDate(@PathParam(value="date") String date) throws Exception {
        List<BackupMetadata> metadata = this.completedBkups.locate(date);
        JSONObject object = new JSONObject();
        ArrayList snapshots = new ArrayList();
        if (metadata != null && !metadata.isEmpty()) {
            snapshots.addAll(metadata.stream().map(backupMetadata -> DateUtil.formatyyyyMMddHHmm(backupMetadata.getStart())).collect(Collectors.toList()));
        }
        object.put("Snapshots", snapshots);
        return Response.ok((Object)object.toString(), (String)"application/json").build();
    }

    private List<BackupMetadata> getLatestBackupMetadata(Date startTime, Date endTime) {
        List<BackupMetadata> backupMetadata = this.completedBkups.locate(endTime);
        if (backupMetadata != null && !backupMetadata.isEmpty()) {
            return backupMetadata;
        }
        if (DateUtil.formatyyyyMMdd(startTime).equals(DateUtil.formatyyyyMMdd(endTime))) {
            logger.info("Start & end date are same. No SNAPSHOT found for date: {}", (Object)DateUtil.formatyyyyMMdd(endTime));
            return null;
        }
        Date previousDay = new Date(endTime.getTime());
        do {
            previousDay = new DateTime(previousDay.getTime()).minusDays(1).toDate();
            logger.info("Will try to find snapshot for previous day: {}", (Object)DateUtil.formatyyyyMMdd(previousDay));
            backupMetadata = this.completedBkups.locate(previousDay);
            if (backupMetadata == null || backupMetadata.isEmpty()) continue;
            return backupMetadata;
        } while (!DateUtil.formatyyyyMMdd(startTime).equals(DateUtil.formatyyyyMMdd(previousDay)));
        return null;
    }

    @GET
    @Path(value="/validate/snapshot/{daterange}")
    @Produces(value={"application/json"})
    public Response validateSnapshotByDate(@PathParam(value="daterange") String daterange) throws Exception {
        Date endTime;
        Date startTime;
        if (StringUtils.isBlank((CharSequence)daterange) || daterange.equalsIgnoreCase("default")) {
            startTime = new DateTime().minusDays(1).toDate();
            endTime = new DateTime().toDate();
        } else {
            String[] dates = daterange.split(",");
            startTime = DateUtil.getDate(dates[0]);
            endTime = DateUtil.getDate(dates[1]);
        }
        JSONObject jsonReply = new JSONObject();
        jsonReply.put("inputStartDate", (Object)DateUtil.formatyyyyMMddHHmm(startTime));
        jsonReply.put("inputEndDate", (Object)DateUtil.formatyyyyMMddHHmm(endTime));
        logger.info("Will try to validate latest backup during startTime: {}, and endTime: {}", (Object)DateUtil.formatyyyyMMddHHmm(startTime), (Object)DateUtil.formatyyyyMMddHHmm(endTime));
        List<BackupMetadata> metadata = this.getLatestBackupMetadata(startTime, endTime);
        BackupVerificationResult result = this.backupVerification.verifyBackup(metadata, startTime);
        jsonReply.put("snapshotAvailable", result.snapshotAvailable);
        jsonReply.put("valid", result.valid);
        jsonReply.put("backupFileListAvailable", result.backupFileListAvail);
        jsonReply.put("metaFileFound", result.metaFileFound);
        jsonReply.put("selectedDate", (Object)result.selectedDate);
        jsonReply.put("snapshotTime", (Object)result.snapshotTime);
        jsonReply.put("filesInMetaOnly", result.filesInMetaOnly);
        jsonReply.put("filesInS3Only", result.filesInS3Only);
        jsonReply.put("filesMatched", result.filesMatched);
        return Response.ok((Object)jsonReply.toString()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/life_of_crow")
    @Produces(value={"application/json"})
    public Response restore_verify_key(@QueryParam(value="daterange") String daterange, @QueryParam(value="region") String region, @QueryParam(value="token") String token, @QueryParam(value="keyspaces") String keyspaces, @QueryParam(value="restoreprefix") String restorePrefix, @QueryParam(value="verifyrowkey") String rowkey, @QueryParam(value="verifyks") String ks, @QueryParam(value="verifycf") String cf, @QueryParam(value="verifyfileextension") String fileExtension) throws Exception {
        SystemUtils.createDirs(SSTABLE2JSON_DIR_LOCATION);
        String JSON_FILE_PATH = "";
        try {
            if (StringUtils.isBlank((CharSequence)daterange) || daterange.equalsIgnoreCase("default")) {
                Response response = Response.ok((Object)"\n[\"daterange can't be blank or default.eg.201311250000,201311260000\"]\n", (String)"application/json").build();
                return response;
            }
            String[] restore = daterange.split(",");
            AbstractBackupPath path = (AbstractBackupPath)this.pathProvider.get();
            Date startTime = path.parseDate(restore[0]);
            Date endTime = path.parseDate(restore[1]);
            String origRestorePrefix = this.config.getRestorePrefix();
            if (StringUtils.isNotBlank((CharSequence)restorePrefix)) {
                this.config.setRestorePrefix(restorePrefix);
            }
            this.restore(token, region, startTime, endTime, keyspaces);
            this.config.setRestorePrefix(origRestorePrefix);
            while (!CassandraMonitor.hasCassadraStarted().booleanValue()) {
                Thread.sleep(1000L);
            }
            JSON_FILE_PATH = daterange.split(",")[0].substring(0, 8) + ".json";
            this.checkSSTablesForKey(rowkey, ks, cf, fileExtension, JSON_FILE_PATH);
        }
        catch (Exception e) {
            logger.info(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            this.removeAllDataFiles(ks);
        }
        return Response.ok((Object)REST_SUCCESS, (String)"application/json").build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restore(String token, String region, Date startTime, Date endTime, String keyspaces) throws Exception {
        String origRegion = this.config.getDC();
        String origToken = this.priamServer.getId().getInstance().getToken();
        if (StringUtils.isNotBlank((CharSequence)token)) {
            this.priamServer.getId().getInstance().setToken(token);
        }
        if (this.config.isRestoreClosestToken()) {
            this.priamServer.getId().getInstance().setToken(this.closestToken(this.priamServer.getId().getInstance().getToken(), this.config.getDC()));
        }
        if (StringUtils.isNotBlank((CharSequence)region)) {
            this.config.setDC(region);
            logger.info("Restoring from region {}", (Object)region);
            this.priamServer.getId().getInstance().setToken(this.closestToken(this.priamServer.getId().getInstance().getToken(), region));
            logger.info("Restore will use token {}", (Object)this.priamServer.getId().getInstance().getToken());
        }
        this.setRestoreKeyspaces(keyspaces);
        try {
            this.restoreObj.restore(startTime, endTime);
        }
        finally {
            this.config.setDC(origRegion);
            this.priamServer.getId().getInstance().setToken(origToken);
        }
        this.tuner.updateAutoBootstrap(this.config.getYamlLocation(), false);
        this.cassProcess.start(true);
    }

    private String closestToken(String token, String region) {
        List plist = this.factory.getAllIds(this.config.getAppName());
        ArrayList tokenList = Lists.newArrayList();
        for (PriamInstance ins : plist) {
            if (!ins.getDC().equalsIgnoreCase(region)) continue;
            tokenList.add(new BigInteger(ins.getToken()));
        }
        return this.tokenManager.findClosestToken(new BigInteger(token), tokenList).toString();
    }

    private void setRestoreKeyspaces(String keyspaces) {
        if (StringUtils.isNotBlank((CharSequence)keyspaces)) {
            ArrayList newKeyspaces = Lists.newArrayList((Object[])keyspaces.split(","));
            this.config.setRestoreKeySpaces(newKeyspaces);
        }
    }

    private JSONObject constructJsonResponse(JSONObject object, Iterator<AbstractBackupPath> it, String filter) throws Exception {
        int fileCnt = 0;
        filter = filter.contains("?") ? filter.substring(0, filter.indexOf("?")) : filter;
        try {
            JSONArray jArray = new JSONArray();
            while (it.hasNext()) {
                AbstractBackupPath p = it.next();
                if (!filter.isEmpty() && AbstractBackupPath.BackupFileType.valueOf(filter) != p.getType()) continue;
                JSONObject backupJSON = new JSONObject();
                backupJSON.put("bucket", (Object)this.config.getBackupPrefix());
                backupJSON.put("filename", (Object)p.getRemotePath());
                backupJSON.put("app", (Object)p.getClusterName());
                backupJSON.put(REST_HEADER_REGION, (Object)p.getRegion());
                backupJSON.put(REST_HEADER_TOKEN, (Object)p.getToken());
                backupJSON.put("ts", (Object)new DateTime((Object)p.getTime()).toString(FMT));
                backupJSON.put("instance_id", (Object)p.getInstanceIdentity().getInstance().getInstanceId());
                backupJSON.put("uploaded_ts", (Object)new DateTime((Object)p.getUploadedTs()).toString(FMT));
                if ("meta".equalsIgnoreCase(filter)) {
                    p.setFileName("meta.json");
                    if (!this.metaData.doesExist(p).booleanValue()) continue;
                    ++fileCnt;
                    jArray.put((Object)backupJSON);
                    backupJSON.put("num_files", (Object)"1");
                    continue;
                }
                ++fileCnt;
                jArray.put((Object)backupJSON);
            }
            object.put("files", (Object)jArray);
            object.put("num_files", fileCnt);
        }
        catch (JSONException jse) {
            logger.info("Caught JSON Exception --> {}", (Object)jse.getMessage());
        }
        return object;
    }

    public void checkSSTablesForKey(String rowkey, String keyspace, String cf, String fileExtension, String jsonFilePath) throws Exception {
        try {
            logger.info("Starting SSTable2Json conversion ...");
            long TIMEOUT_PERIOD = 10L;
            String unixCmd = this.formulateCommandToRun(rowkey, keyspace, cf, fileExtension, jsonFilePath);
            String[] cmd = new String[]{"/bin/sh", "-c", unixCmd};
            final Process p = Runtime.getRuntime().exec(cmd);
            Callable<Integer> callable = new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return p.waitFor();
                }
            };
            ExecutorService exeService = Executors.newSingleThreadExecutor();
            try {
                Future<Integer> future = exeService.submit(callable);
                int returnVal = future.get(TIMEOUT_PERIOD, TimeUnit.MINUTES);
                if (returnVal == 0) {
                    logger.info("Finished SSTable2Json conversion and search.");
                } else {
                    logger.error("Error occurred during SSTable2Json conversion and search.");
                }
            }
            catch (TimeoutException e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                throw e;
            }
            finally {
                p.destroy();
                exeService.shutdown();
            }
        }
        catch (IOException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public String formulateCommandToRun(String rowkey, String keyspace, String cf, String fileExtension, String jsonFilePath) {
        StringBuffer sbuff = new StringBuffer();
        sbuff.append("for i in $(ls " + this.config.getDataFileLocation() + File.separator + keyspace + File.separator + cf + File.separator + fileExtension + "-*-Data.db); do " + this.config.getCassHome() + SSTABLE2JSON_COMMAND_FROM_CASSHOME + " $i -k ");
        sbuff.append(rowkey);
        sbuff.append("  | grep ");
        sbuff.append(rowkey);
        sbuff.append(" >> ");
        sbuff.append(SSTABLE2JSON_DIR_LOCATION + File.separator + jsonFilePath);
        sbuff.append(" ; done");
        logger.info("SSTable2JSON location </tmp/priam_sstables{}{}>", (Object)File.separator, (Object)jsonFilePath);
        logger.info("Running Command = {}", (Object)sbuff);
        return sbuff.toString();
    }

    public void removeAllDataFiles(String ks) throws Exception {
        String cleanupDirPath = this.config.getDataFileLocation() + File.separator + ks;
        logger.info("Starting to clean all the files inside <{}>", (Object)cleanupDirPath);
        SystemUtils.cleanupDir(cleanupDirPath, null);
        logger.info("*** Done cleaning all the files inside <{}>", (Object)cleanupDirPath);
    }
}

