/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.resources;

import com.google.inject.Inject;
import com.netflix.priam.identity.IMembership;
import java.util.Collections;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/secgroup")
@Produces(value={"text/plain"})
public class SecurityGroupAdmin {
    private static final Logger log = LoggerFactory.getLogger(SecurityGroupAdmin.class);
    private static final String CIDR_TAG = "/32";
    private final IMembership membership;

    @Inject
    public SecurityGroupAdmin(IMembership membership) {
        this.membership = membership;
    }

    @POST
    public Response addACL(@QueryParam(value="ip") String ipAddr, @QueryParam(value="fromPort") int fromPort, @QueryParam(value="toPort") int toPort) {
        if (!ipAddr.endsWith(CIDR_TAG)) {
            ipAddr = ipAddr + CIDR_TAG;
        }
        try {
            this.membership.addACL(Collections.singletonList(ipAddr), fromPort, toPort);
        }
        catch (Exception e) {
            log.error("Error while trying to add an ACL to a security group", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.ok().build();
    }

    @DELETE
    public Response removeACL(@QueryParam(value="ip") String ipAddr, @QueryParam(value="fromPort") int fromPort, @QueryParam(value="toPort") int toPort) {
        if (!ipAddr.endsWith(CIDR_TAG)) {
            ipAddr = ipAddr + CIDR_TAG;
        }
        try {
            this.membership.removeACL(Collections.singletonList(ipAddr), fromPort, toPort);
        }
        catch (Exception e) {
            log.error("Error while trying to remove an ACL to a security group", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.ok().build();
    }
}

