/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.restore;

import com.google.inject.Provider;
import com.netflix.priam.backup.AbstractBackupPath;
import com.netflix.priam.backup.IBackupFileSystem;
import com.netflix.priam.backup.MetaData;
import com.netflix.priam.compress.ICompression;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.cred.ICredentialGeneric;
import com.netflix.priam.cryptography.IFileCryptography;
import com.netflix.priam.defaultimpl.ICassandraProcess;
import com.netflix.priam.health.InstanceState;
import com.netflix.priam.identity.InstanceIdentity;
import com.netflix.priam.restore.AbstractRestore;
import com.netflix.priam.restore.IPostRestoreHook;
import com.netflix.priam.restore.RestoreTokenSelector;
import com.netflix.priam.scheduler.NamedThreadPoolExecutor;
import com.netflix.priam.utils.RetryableCallable;
import com.netflix.priam.utils.Sleeper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.bouncycastle.util.io.Streams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EncryptedRestoreBase
extends AbstractRestore {
    private static final Logger logger = LoggerFactory.getLogger(EncryptedRestoreBase.class);
    private String jobName;
    private ICredentialGeneric pgpCredential;
    private IFileCryptography fileCryptography;
    private ICompression compress;
    private final ThreadPoolExecutor executor;
    private AtomicInteger count = new AtomicInteger();

    protected EncryptedRestoreBase(IConfiguration config, IBackupFileSystem fs, String jobName, Sleeper sleeper, ICassandraProcess cassProcess, Provider<AbstractBackupPath> pathProvider, InstanceIdentity instanceIdentity, RestoreTokenSelector tokenSelector, ICredentialGeneric pgpCredential, IFileCryptography fileCryptography, ICompression compress, MetaData metaData, InstanceState instanceState, IPostRestoreHook postRestoreHook) {
        super(config, fs, jobName, sleeper, pathProvider, instanceIdentity, tokenSelector, cassProcess, metaData, instanceState, postRestoreHook);
        this.jobName = jobName;
        this.pgpCredential = pgpCredential;
        this.fileCryptography = fileCryptography;
        this.compress = compress;
        this.executor = new NamedThreadPoolExecutor(config.getMaxBackupDownloadThreads(), jobName);
        this.executor.allowCoreThreadTimeOut(true);
        logger.info("Trying to restore cassandra cluster with filesystem: {}, RestoreStrategy: {}, Encryption: ON, Compression: {}", new Object[]{fs.getClass(), jobName, compress.getClass()});
    }

    @Override
    protected final void downloadFile(final AbstractBackupPath path, final File restoreLocation) throws Exception {
        final char[] passPhrase = new String(this.pgpCredential.getValue(ICredentialGeneric.KEY.PGP_PASSWORD)).toCharArray();
        final File tempFile = new File(restoreLocation.getAbsolutePath() + ".tmp");
        this.count.incrementAndGet();
        try {
            this.executor.submit(new RetryableCallable<Integer>(){

                @Override
                public Integer retriableCall() throws Exception {
                    Throwable throwable;
                    Throwable throwable2;
                    try {
                        logger.info("Downloading file from: {} to: {}", (Object)path.getRemotePath(), (Object)tempFile.getAbsolutePath());
                        EncryptedRestoreBase.this.fs.download(path, new FileOutputStream(tempFile), tempFile.getAbsolutePath());
                        AbstractRestore.tracker.adjustAndAdd(path);
                        logger.info("Completed downloading file from: {} to: {}", (Object)path.getRemotePath(), (Object)tempFile.getAbsolutePath());
                    }
                    catch (Exception ex) {
                        if (tempFile.exists()) {
                            tempFile.createNewFile();
                        }
                        throw new Exception("Exception downloading file from: " + path.getRemotePath() + " to: " + tempFile.getAbsolutePath(), ex);
                    }
                    File decryptedFile = new File(tempFile.getAbsolutePath() + ".decrypted");
                    try {
                        throwable2 = null;
                        try (BufferedOutputStream fOut = new BufferedOutputStream(new FileOutputStream(decryptedFile));){
                            throwable = null;
                            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(tempFile.getAbsolutePath()));){
                                InputStream encryptedDataInputStream = EncryptedRestoreBase.this.fileCryptography.decryptStream(in, passPhrase, tempFile.getAbsolutePath());
                                Streams.pipeAll((InputStream)encryptedDataInputStream, (OutputStream)fOut);
                                logger.info("Completed decrypting file: {} to final file dest: {}", (Object)tempFile.getAbsolutePath(), (Object)decryptedFile.getAbsolutePath());
                            }
                            catch (Throwable throwable3) {
                                throwable = throwable3;
                                throw throwable3;
                            }
                        }
                        catch (Throwable in) {
                            throwable2 = in;
                            throw in;
                        }
                    }
                    catch (Exception ex) {
                        if (tempFile.exists()) {
                            tempFile.createNewFile();
                        }
                        if (decryptedFile.exists()) {
                            decryptedFile.createNewFile();
                        }
                        throw new Exception("Exception during decryption file:  " + decryptedFile.getAbsolutePath(), ex);
                    }
                    logger.info("Start uncompressing file: {} to the FINAL destination stream", (Object)decryptedFile.getAbsolutePath());
                    try {
                        throwable2 = null;
                        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(decryptedFile));){
                            throwable = null;
                            try (BufferedOutputStream finalDestination = new BufferedOutputStream(new FileOutputStream(restoreLocation));){
                                EncryptedRestoreBase.this.compress.decompressAndClose(is, finalDestination);
                            }
                            catch (Throwable throwable4) {
                                throwable = throwable4;
                                throw throwable4;
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable2 = throwable5;
                            throw throwable5;
                        }
                    }
                    catch (Exception ex) {
                        throw new Exception("Exception uncompressing file: " + decryptedFile.getAbsolutePath() + " to the FINAL destination stream", ex);
                    }
                    logger.info("Completed uncompressing file: {} to the FINAL destination stream  current worker: {}", (Object)decryptedFile.getAbsolutePath(), (Object)Thread.currentThread().getName());
                    if (tempFile.exists()) {
                        tempFile.delete();
                    }
                    if (decryptedFile.exists()) {
                        decryptedFile.delete();
                    }
                    return EncryptedRestoreBase.this.count.decrementAndGet();
                }
            });
        }
        catch (Exception e) {
            throw new Exception("Exception in download of:  " + path.getFileName() + ", msg: " + e.getLocalizedMessage(), e);
        }
    }

    @Override
    protected final void waitToComplete() {
        while (this.count.get() != 0) {
            try {
                this.sleeper.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.error("Interrupted: ", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public String getName() {
        return this.jobName;
    }
}

