/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.restore;

import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.restore.IPostRestoreHook;
import com.netflix.priam.restore.PostRestoreHookException;
import com.netflix.priam.scheduler.NamedThreadPoolExecutor;
import com.netflix.priam.utils.RetryableCallable;
import com.netflix.priam.utils.Sleeper;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostRestoreHook
implements IPostRestoreHook {
    private static final Logger logger = LoggerFactory.getLogger(PostRestoreHook.class);
    private final IConfiguration config;
    private final Sleeper sleeper;
    private static String PostRestoreHookCommandDelimiter = " ";
    private static String PriamPostRestoreHookFilePrefix = "PriamFileForPostRestoreHook";
    private static String PriamPostRestoreHookFileSuffix = ".tmp";
    private static String PriamPostRestoreHookFileOptionName = "--parentHookFilePath=";

    @Inject
    public PostRestoreHook(IConfiguration config, Sleeper sleeper) {
        this.config = config;
        this.sleeper = sleeper;
    }

    @Override
    public boolean hasValidParameters() {
        return !this.config.isPostRestoreHookEnabled() || !StringUtils.isBlank((CharSequence)this.config.getPostRestoreHook()) && !StringUtils.isBlank((CharSequence)this.config.getPostRestoreHookHeartbeatFileName()) && !StringUtils.isBlank((CharSequence)this.config.getPostRestoreHookDoneFileName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Exception {
        block9: {
            if (this.config.isPostRestoreHookEnabled()) {
                logger.debug("Started PostRestoreHook execution");
                File tempLockFile = File.createTempFile(PriamPostRestoreHookFilePrefix, PriamPostRestoreHookFileSuffix);
                RandomAccessFile raf = new RandomAccessFile(tempLockFile.getPath(), "rw");
                FileChannel fileChannel = raf.getChannel();
                FileLock lock = fileChannel.lock();
                try {
                    if (lock.isValid()) {
                        logger.info("Lock on RestoreHookFile acquired");
                        int countOfProcessStarts = 0;
                        while (true) {
                            if (this.doneFileExists()) {
                                logger.info("Not starting PostRestoreHook since DONE file already exists.");
                                break;
                            }
                            String postRestoreHook = this.config.getPostRestoreHook();
                            postRestoreHook = postRestoreHook + PostRestoreHookCommandDelimiter + PriamPostRestoreHookFileOptionName + tempLockFile.getAbsolutePath();
                            String[] processCommandArguments = postRestoreHook.split(PostRestoreHookCommandDelimiter);
                            ProcessBuilder processBuilder = new ProcessBuilder(processCommandArguments);
                            Process process = processBuilder.inheritIO().start();
                            logger.info("Started PostRestoreHook: {} - Attempt#{}", (Object)postRestoreHook, (Object)(++countOfProcessStarts));
                            this.monitorPostRestoreHookHeartBeat(process);
                            if (!process.waitFor(this.config.getPostRestoreHookTimeOutInDays(), TimeUnit.DAYS)) {
                                logger.info("PostRestoreHook process did not complete within {} days. Forcefully terminating the process.", (Object)this.config.getPostRestoreHookTimeOutInDays());
                                process.destroyForcibly();
                            }
                            if (process.exitValue() == 0) {
                                logger.info("PostRestoreHook process completed successfully");
                                break;
                            }
                            logger.warn("PostRestoreHook process exited unsuccessfully");
                        }
                        logger.debug("Completed PostRestoreHook execution");
                        break block9;
                    }
                    throw new PostRestoreHookException(String.format("Could not acquire lock on a temp file necessary for PostRestoreHook to execute. Path to temp file: %s", tempLockFile.getAbsolutePath()));
                }
                finally {
                    lock.release();
                    fileChannel.close();
                    raf.close();
                    tempLockFile.delete();
                }
            }
        }
    }

    private void monitorPostRestoreHookHeartBeat(final Process process) throws InterruptedException, IOException {
        final File heartBeatFile = new File(this.config.getPostRestoreHookHeartbeatFileName());
        NamedThreadPoolExecutor heartBeatPoolExecutor = new NamedThreadPoolExecutor(1, "PostRestoreHook_HeartBeatThreadPool");
        heartBeatPoolExecutor.allowCoreThreadTimeOut(true);
        heartBeatPoolExecutor.submit(new RetryableCallable<Integer>(){

            @Override
            public Integer retriableCall() throws Exception {
                do {
                    PostRestoreHook.this.sleeper.sleep(PostRestoreHook.this.config.getPostRestoreHookHeartbeatCheckFrequencyInMs());
                } while (System.currentTimeMillis() - heartBeatFile.lastModified() <= (long)PostRestoreHook.this.config.getPostRestoreHookHeartBeatTimeoutInMs());
                logger.info("No heartbeat for the last {} ms, killing the existing process.", (Object)PostRestoreHook.this.config.getPostRestoreHookHeartBeatTimeoutInMs());
                if (process.isAlive()) {
                    process.destroyForcibly();
                }
                return 0;
            }
        });
    }

    private boolean doneFileExists() {
        File doneFile = new File(this.config.getPostRestoreHookDoneFileName());
        return doneFile.exists();
    }
}

