/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.tuner;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class JVMOption {
    private String jvmOption;
    private String value;
    private boolean isCommented;
    private boolean isHeapJVMOption;
    private static final Pattern pattern = Pattern.compile("(#)*(-[^=]+)=?(.*)?");
    private static final Pattern heapPattern = Pattern.compile("(#)*(-Xm[x|s|n])([0-9]+[K|M|G])?");

    public JVMOption(String jvmOption) {
        this.jvmOption = jvmOption;
    }

    public JVMOption(String jvmOption, String value, boolean isCommented, boolean isHeapJVMOption) {
        this.jvmOption = jvmOption;
        this.value = value;
        this.isCommented = isCommented;
        this.isHeapJVMOption = isHeapJVMOption;
    }

    public String toJVMOptionString() {
        StringBuffer sb = new StringBuffer();
        if (this.isCommented) {
            sb.append("#");
        }
        sb.append(this.jvmOption);
        if (this.value != null) {
            if (!this.isHeapJVMOption) {
                sb.append("=");
            }
            sb.append(this.value);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JVMOption jvmOption1 = (JVMOption)o;
        return this.isCommented == jvmOption1.isCommented && this.isHeapJVMOption == jvmOption1.isHeapJVMOption && Objects.equals(this.jvmOption, jvmOption1.jvmOption) && Objects.equals(this.value, jvmOption1.value);
    }

    public int hashCode() {
        return Objects.hash(this.jvmOption, this.value, this.isCommented, this.isHeapJVMOption);
    }

    public String getJvmOption() {
        return this.jvmOption;
    }

    public JVMOption setJvmOption(String jvmOption) {
        this.jvmOption = jvmOption.trim();
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public JVMOption setValue(String value) {
        if (!StringUtils.isEmpty((CharSequence)value)) {
            this.value = value;
        }
        return this;
    }

    public boolean isCommented() {
        return this.isCommented;
    }

    public JVMOption setCommented(boolean commented) {
        this.isCommented = commented;
        return this;
    }

    public boolean isHeapJVMOption() {
        return this.isHeapJVMOption;
    }

    public JVMOption setHeapJVMOption(boolean heapJVMOption) {
        this.isHeapJVMOption = heapJVMOption;
        return this;
    }

    public static JVMOption parse(String line) {
        JVMOption result = null;
        Matcher matcher = heapPattern.matcher(line);
        if (matcher.matches()) {
            boolean isCommented = matcher.group(1) != null;
            return new JVMOption(matcher.group(2)).setCommented(isCommented).setValue(matcher.group(3)).setHeapJVMOption(true);
        }
        matcher = pattern.matcher(line);
        if (matcher.matches()) {
            boolean isCommented = matcher.group(1) != null;
            return new JVMOption(matcher.group(2)).setCommented(isCommented).setValue(matcher.group(3));
        }
        return result;
    }
}

