/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.tuner;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.health.InstanceState;
import com.netflix.priam.scheduler.SimpleTimer;
import com.netflix.priam.scheduler.Task;
import com.netflix.priam.scheduler.TaskTimer;
import com.netflix.priam.tuner.ICassandraTuner;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TuneCassandra
extends Task {
    private static final String JOBNAME = "Tune-Cassandra";
    private static final Logger LOGGER = LoggerFactory.getLogger(TuneCassandra.class);
    private final ICassandraTuner tuner;
    private InstanceState instanceState;

    @Inject
    public TuneCassandra(IConfiguration config, ICassandraTuner tuner, InstanceState instanceState) {
        super(config);
        this.tuner = tuner;
        this.instanceState = instanceState;
    }

    @Override
    public void execute() throws Exception {
        boolean isDone = false;
        while (!isDone) {
            try {
                this.tuner.writeAllProperties(this.config.getYamlLocation(), null, this.config.getSeedProviderName());
                this.tuner.updateJVMOptions();
                isDone = true;
                this.instanceState.setYmlWritten(true);
            }
            catch (IOException e) {
                LOGGER.error("Fail wrting cassandra.yml file. Retry again!", (Throwable)e);
            }
        }
    }

    @Override
    public String getName() {
        return JOBNAME;
    }

    public static TaskTimer getTimer() {
        return new SimpleTimer(JOBNAME);
    }
}

