/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.tuner.dse;

import com.google.common.base.Joiner;
import com.google.common.io.Files;
import com.google.inject.Inject;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.tuner.dse.IAuditLogTuner;
import com.netflix.priam.tuner.dse.IDseConfiguration;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.cassandra.io.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogTunerLog4J
implements IAuditLogTuner {
    private IConfiguration config;
    private IDseConfiguration dseConfig;
    protected static final String AUDIT_LOG_ADDITIVE_ENTRY = "log4j.additivity.DataAudit";
    protected static final String AUDIT_LOG_FILE = "/conf/log4j-server.properties";
    protected static final String PRIMARY_AUDIT_LOG_ENTRY = "log4j.logger.DataAudit";
    private static final Logger logger = LoggerFactory.getLogger(AuditLogTunerLog4J.class);

    @Inject
    public AuditLogTunerLog4J(IConfiguration config, IDseConfiguration dseConfig) {
        this.config = config;
        this.dseConfig = dseConfig;
    }

    @Override
    public void tuneAuditLog() {
        BufferedWriter writer = null;
        File srcFile = new File(this.config.getCassHome() + AUDIT_LOG_FILE);
        List lines = Files.readLines((File)srcFile, (Charset)Charset.defaultCharset());
        File backupFile = new File(this.config.getCassHome() + AUDIT_LOG_FILE + "." + System.currentTimeMillis());
        Files.move((File)srcFile, (File)backupFile);
        writer = Files.newWriter((File)srcFile, (Charset)Charset.defaultCharset());
        String loggerPrefix = "log4j.appender.";
        try {
            loggerPrefix = loggerPrefix + this.findAuditLoggerName(lines);
        }
        catch (IllegalStateException ise) {
            logger.warn("cannot locate log4j.logger.DataAudit property, will ignore any audit log updating");
            FileUtils.closeQuietly((Closeable)writer);
            return;
        }
        try {
            for (String line : lines) {
                if (line.contains(loggerPrefix) || line.contains(PRIMARY_AUDIT_LOG_ENTRY) || line.contains(AUDIT_LOG_ADDITIVE_ENTRY)) {
                    if (this.dseConfig.isAuditLogEnabled()) {
                        while (line.startsWith("#")) {
                            line = line.substring(1);
                        }
                        if (line.contains("ActiveCategories")) {
                            String cats = Joiner.on((String)",").join(this.dseConfig.getAuditLogCategories());
                            line = line.substring(0, line.indexOf("=") + 1).concat(cats);
                        } else if (line.contains("ExemptKeyspaces")) {
                            line = line.substring(0, line.indexOf("=") + 1).concat(this.dseConfig.getAuditLogExemptKeyspaces());
                        }
                    } else if (line.startsWith("#")) {
                        while (line.charAt(1) == '#') {
                            line = line.substring(1);
                        }
                    } else {
                        line = "#" + line;
                    }
                }
                writer.append(line);
                writer.newLine();
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new RuntimeException("Unable to read /conf/log4j-server.properties", e);
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        FileUtils.closeQuietly((Closeable)writer);
    }

    private final String findAuditLoggerName(List<String> lines) throws IllegalStateException {
        for (String l : lines) {
            if (!l.contains(PRIMARY_AUDIT_LOG_ENTRY)) continue;
            String[] valTokens = l.split(",");
            return valTokens[valTokens.length - 1].trim();
        }
        throw new IllegalStateException();
    }
}

