/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.tuner.dse;

import com.google.inject.Inject;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.defaultimpl.CassandraProcessManager;
import com.netflix.priam.health.InstanceState;
import com.netflix.priam.merics.CassMonitorMetrics;
import com.netflix.priam.tuner.dse.IDseConfiguration;
import java.util.Map;

public class DseProcessManager
extends CassandraProcessManager {
    private final IDseConfiguration dseConfig;

    @Inject
    public DseProcessManager(IConfiguration config, IDseConfiguration dseConfig, InstanceState instanceState, CassMonitorMetrics cassMonitorMetrics) {
        super(config, instanceState, cassMonitorMetrics);
        this.dseConfig = dseConfig;
    }

    @Override
    protected void setEnv(Map<String, String> env) {
        super.setEnv(env);
        IDseConfiguration.NodeType nodeType = this.dseConfig.getNodeType();
        if (nodeType == IDseConfiguration.NodeType.ANALYTIC_HADOOP) {
            env.put("CLUSTER_TYPE", "-t");
        } else if (nodeType == IDseConfiguration.NodeType.ANALYTIC_SPARK) {
            env.put("CLUSTER_TYPE", "-k");
        } else if (nodeType == IDseConfiguration.NodeType.ANALYTIC_HADOOP_SPARK) {
            env.put("CLUSTER_TYPE", "-k -t");
        } else if (nodeType == IDseConfiguration.NodeType.SEARCH) {
            env.put("CLUSTER_TYPE", "-s");
        }
    }
}

