/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.utils;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.DateUtils;

@Singleton
public class DateUtil {
    public static final String yyyyMMdd = "yyyyMMdd";
    public static final String yyyyMMddHHmm = "yyyyMMddHHmm";
    public static final String ddMMyyyyHHmm = "ddMMyyyyHHmm";
    private static final String[] patterns = new String[]{"yyyyMMddHHmm", "yyyyMMdd", "ddMMyyyyHHmm"};
    private static final ZoneId defaultZoneId = ZoneId.systemDefault();
    private static final ZoneId utcZoneId = ZoneId.of("UTC");

    public static String formatyyyyMMdd(Date date) {
        if (date == null) {
            return null;
        }
        return DateUtils.formatDate((Date)date, (String)yyyyMMdd);
    }

    public static String formatyyyyMMddHHmm(Date date) {
        if (date == null) {
            return null;
        }
        return DateUtils.formatDate((Date)date, (String)yyyyMMddHHmm);
    }

    public static String formatDate(Date date, String pattern) {
        return DateUtils.formatDate((Date)date, (String)pattern);
    }

    public static Date getDate(String date) {
        if (StringUtils.isEmpty((CharSequence)date)) {
            return null;
        }
        return DateUtils.parseDate((String)date, (String[])patterns);
    }

    public static LocalDateTime convert(Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant().atZone(defaultZoneId).toLocalDateTime();
    }

    public static String formatyyyyMMdd(LocalDateTime date) {
        if (date == null) {
            return null;
        }
        return date.format(DateTimeFormatter.ofPattern(yyyyMMdd));
    }

    public static String formatyyyyMMddHHmm(LocalDateTime date) {
        if (date == null) {
            return null;
        }
        return date.format(DateTimeFormatter.ofPattern(yyyyMMddHHmm));
    }

    public static LocalDateTime getLocalDateTime(String date) {
        if (StringUtils.isEmpty((CharSequence)date)) {
            return null;
        }
        for (String pattern : patterns) {
            LocalDateTime localDateTime = LocalDateTime.parse(date, DateTimeFormatter.ofPattern(pattern));
            if (localDateTime == null) continue;
            return localDateTime;
        }
        return null;
    }

    public static Instant getInstant() {
        return Instant.now();
    }

    public static String formatInstant(String pattern, Instant instant) {
        if (instant == null || StringUtils.isEmpty((CharSequence)pattern)) {
            return null;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern).withZone(utcZoneId);
        return formatter.format(instant);
    }

    public static final Instant parseInstant(String dateTime) {
        if (StringUtils.isEmpty((CharSequence)dateTime)) {
            return null;
        }
        for (String pattern : patterns) {
            try {
                Instant instant = DateTimeFormatter.ofPattern(pattern).withZone(utcZoneId).parse((CharSequence)dateTime, Instant::from);
                if (instant == null) continue;
                return instant;
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return null;
    }
}

