/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.utils;

import com.netflix.priam.utils.RetryableCallable;
import java.util.concurrent.CancellationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExponentialRetryCallable<T>
extends RetryableCallable<T> {
    public static final long MAX_SLEEP = 240000L;
    public static final long MIN_SLEEP = 200L;
    private static final Logger logger = LoggerFactory.getLogger(ExponentialRetryCallable.class);
    private long max;
    private long min;

    public ExponentialRetryCallable() {
        this.max = 240000L;
        this.min = 200L;
    }

    public ExponentialRetryCallable(long minSleep, long maxSleep) {
        this.max = maxSleep;
        this.min = minSleep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T call() throws Exception {
        long delay = this.min;
        while (true) {
            try {
                Object t = this.retriableCall();
                return t;
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (Exception e) {
                if ((delay *= 2L) > this.max) {
                    throw e;
                }
                logger.error(e.getMessage());
                Thread.sleep(delay);
                continue;
            }
            finally {
                this.forEachExecution();
                continue;
            }
            break;
        }
    }
}

