/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.netflix.priam.aws.UpdateCleanupPolicy;
import com.netflix.priam.aws.UpdateSecuritySettings;
import com.netflix.priam.backup.CommitLogBackupTask;
import com.netflix.priam.backup.IncrementalBackup;
import com.netflix.priam.backup.SnapshotBackup;
import com.netflix.priam.backup.parallel.IncrementalBackupProducer;
import com.netflix.priam.cluster.management.Compaction;
import com.netflix.priam.cluster.management.Flush;
import com.netflix.priam.cluster.management.IClusterManagement;
import com.netflix.priam.config.IBackupRestoreConfig;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.defaultimpl.ICassandraProcess;
import com.netflix.priam.identity.InstanceIdentity;
import com.netflix.priam.restore.RestoreContext;
import com.netflix.priam.scheduler.PriamScheduler;
import com.netflix.priam.scheduler.TaskTimer;
import com.netflix.priam.services.SnapshotMetaService;
import com.netflix.priam.tuner.TuneCassandra;
import com.netflix.priam.utils.CassandraMonitor;
import com.netflix.priam.utils.Sleeper;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PriamServer {
    private final PriamScheduler scheduler;
    private final IConfiguration config;
    private final IBackupRestoreConfig backupRestoreConfig;
    private final InstanceIdentity id;
    private final Sleeper sleeper;
    private final ICassandraProcess cassProcess;
    private final RestoreContext restoreContext;
    private static final int CASSANDRA_MONITORING_INITIAL_DELAY = 10;
    private static final Logger logger = LoggerFactory.getLogger(PriamServer.class);

    @Inject
    public PriamServer(IConfiguration config, IBackupRestoreConfig backupRestoreConfig, PriamScheduler scheduler, InstanceIdentity id, Sleeper sleeper, ICassandraProcess cassProcess, RestoreContext restoreContext) {
        this.config = config;
        this.backupRestoreConfig = backupRestoreConfig;
        this.scheduler = scheduler;
        this.id = id;
        this.sleeper = sleeper;
        this.cassProcess = cassProcess;
        this.restoreContext = restoreContext;
    }

    public void initialize() throws Exception {
        TaskTimer compactionTimer;
        if (this.id.getInstance().isOutOfService()) {
            return;
        }
        this.scheduler.start();
        if (this.config.isMultiDC()) {
            this.scheduler.runTaskNow(UpdateSecuritySettings.class);
            if (this.id.isReplace() || this.id.isTokenPregenerated()) {
                this.sleeper.sleep(150000L);
            } else if (UpdateSecuritySettings.firstTimeUpdated) {
                this.sleeper.sleep(60000L);
            }
            this.scheduler.addTask("Update_SG", UpdateSecuritySettings.class, UpdateSecuritySettings.getTimer(this.id));
        }
        this.scheduler.runTaskNow(TuneCassandra.class);
        if (SnapshotBackup.getTimer(this.config) != null && (CollectionUtils.isEmpty(this.config.getBackupRacs()) || this.config.getBackupRacs().contains(this.config.getRac()))) {
            this.scheduler.addTask("SnapshotBackup", SnapshotBackup.class, SnapshotBackup.getTimer(this.config));
            if (this.config.isIncrBackup()) {
                if (!this.config.isIncrBackupParallelEnabled().booleanValue()) {
                    this.scheduler.addTask("IncrementalBackup", IncrementalBackup.class, IncrementalBackup.getTimer());
                    logger.info("Added incremental synchronous bkup");
                } else {
                    this.scheduler.addTask("ParallelIncremental", IncrementalBackupProducer.class, IncrementalBackupProducer.getTimer());
                    logger.info("Added incremental async-synchronous bkup, next fired time: {}", (Object)IncrementalBackupProducer.getTimer().getTrigger().getNextFireTime());
                }
            }
        }
        if (this.config.isBackingUpCommitLogs()) {
            this.scheduler.addTask(CommitLogBackupTask.JOBNAME, CommitLogBackupTask.class, CommitLogBackupTask.getTimer(this.config));
        }
        if (this.restoreContext.isRestoreEnabled()) {
            this.restoreContext.restore();
        } else {
            logger.info("No restore needed, task not scheduled");
            if (!this.config.doesCassandraStartManually()) {
                this.cassProcess.start(true);
            } else {
                logger.info("config.doesCassandraStartManually() is set to True, hence Cassandra needs to be started manually ...");
            }
        }
        this.scheduler.addTaskWithDelay("CASS_MONITOR_THREAD", CassandraMonitor.class, CassandraMonitor.getTimer(), 10);
        this.scheduler.addTask("UpdateCleanupPolicy", UpdateCleanupPolicy.class, UpdateCleanupPolicy.getTimer());
        TaskTimer flushTaskTimer = Flush.getTimer(this.config);
        if (flushTaskTimer != null) {
            this.scheduler.addTask(IClusterManagement.Task.FLUSH.name(), Flush.class, flushTaskTimer);
            logger.info("Added nodetool flush task.");
        }
        if ((compactionTimer = Compaction.getTimer(this.config)) != null) {
            this.scheduler.addTask(IClusterManagement.Task.COMPACTION.name(), Compaction.class, compactionTimer);
            logger.info("Added compaction task.");
        }
        this.setUpSnapshotService();
    }

    private void setUpSnapshotService() throws Exception {
        TaskTimer snapshotMetaServiceTimer = SnapshotMetaService.getTimer(this.backupRestoreConfig);
        if (snapshotMetaServiceTimer != null) {
            this.scheduler.addTask("SnapshotMetaService", SnapshotMetaService.class, snapshotMetaServiceTimer);
            logger.info("Added SnapshotMetaService Task.");
        }
    }

    public InstanceIdentity getId() {
        return this.id;
    }

    public PriamScheduler getScheduler() {
        return this.scheduler;
    }

    public IConfiguration getConfiguration() {
        return this.config;
    }
}

