/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.backup;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.netflix.priam.backup.IBackupFileSystem;
import com.netflix.priam.backup.IFileSystemContext;
import com.netflix.priam.config.IConfiguration;

public class BackupFileSystemContext
implements IFileSystemContext {
    private IBackupFileSystem fs = null;
    private IBackupFileSystem encryptedFs = null;

    @Inject
    public BackupFileSystemContext(@Named(value="backup") IBackupFileSystem fs, @Named(value="encryptedbackup") IBackupFileSystem encryptedFs) {
        this.fs = fs;
        this.encryptedFs = encryptedFs;
    }

    @Override
    public IBackupFileSystem getFileStrategy(IConfiguration config) {
        if (!config.isEncryptBackupEnabled()) {
            return this.fs;
        }
        return this.encryptedFs;
    }
}

