/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.backup;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.netflix.priam.backup.AbstractBackupPath;
import com.netflix.priam.backup.BackupMetadata;
import com.netflix.priam.backup.BackupVerificationResult;
import com.netflix.priam.backup.IBackupFileSystem;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.utils.DateUtil;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.json.simple.JSONArray;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class BackupVerification {
    private static final Logger logger = LoggerFactory.getLogger(BackupVerification.class);
    private IBackupFileSystem bkpStatusFs;
    private IConfiguration config;

    @Inject
    BackupVerification(@Named(value="backup_status") IBackupFileSystem bkpStatusFs, IConfiguration config) {
        this.bkpStatusFs = bkpStatusFs;
        this.config = config;
    }

    public BackupVerificationResult verifyBackup(List<BackupMetadata> metadata, Date startTime) {
        BackupVerificationResult result = new BackupVerificationResult();
        if (metadata == null || metadata.isEmpty()) {
            return result;
        }
        result.snapshotAvailable = true;
        result.selectedDate = metadata.get(0).getSnapshotDate();
        List backups = metadata.stream().map(backupMetadata -> DateUtil.formatyyyyMMddHHmm(backupMetadata.getStart())).collect(Collectors.toList());
        logger.info("Snapshots found for {} : [{}]", (Object)result.selectedDate, backups);
        Date latestDate = null;
        for (BackupMetadata backupMetadata2 : metadata) {
            if (latestDate == null || latestDate.before(backupMetadata2.getStart())) {
                latestDate = backupMetadata2.getStart();
            }
            if (startTime == null || !DateUtil.formatyyyyMMddHHmm(backupMetadata2.getStart()).equals(DateUtil.formatyyyyMMddHHmm(startTime))) continue;
            latestDate = startTime;
            break;
        }
        result.snapshotTime = DateUtil.formatyyyyMMddHHmm(latestDate);
        logger.info("Latest/Requested snapshot date found: {}, for selected/provided date: {}", (Object)result.snapshotTime, (Object)result.selectedDate);
        String prefix = this.config.getBackupPrefix();
        logger.info("Looking for meta file in the location:  {}", (Object)prefix);
        Date strippedMsSnapshotTime = DateUtil.getDate(result.snapshotTime);
        Iterator<AbstractBackupPath> backupfiles = this.bkpStatusFs.list(prefix, strippedMsSnapshotTime, strippedMsSnapshotTime);
        if (!backupfiles.hasNext()) {
            logger.warn("ERROR: No files available while doing backup filesystem listing. Declaring the verification failed.");
            return result;
        }
        result.backupFileListAvail = true;
        LinkedList<AbstractBackupPath> metas = new LinkedList<AbstractBackupPath>();
        ArrayList<String> s3Listing = new ArrayList<String>();
        while (backupfiles.hasNext()) {
            AbstractBackupPath path = backupfiles.next();
            if (path.getFileName().equalsIgnoreCase("meta.json")) {
                metas.add(path);
                continue;
            }
            s3Listing.add(path.getRemotePath());
        }
        if (metas.size() == 0) {
            logger.error("No meta found for snapshotdate: {}", (Object)DateUtil.formatyyyyMMddHHmm(latestDate));
            return result;
        }
        result.metaFileFound = true;
        ArrayList<String> metaFileList = new ArrayList<String>();
        try {
            Path metaFileLocation = FileSystems.getDefault().getPath(this.config.getDataFileLocation(), "tmp_meta.json");
            this.bkpStatusFs.download((AbstractBackupPath)metas.get(0), new FileOutputStream(metaFileLocation.toFile()));
            logger.info("Meta file successfully downloaded to localhost: {}", (Object)metaFileLocation.toString());
            JSONParser jsonParser = new JSONParser();
            JSONArray fileList = (JSONArray)jsonParser.parse((Reader)new FileReader(metaFileLocation.toFile()));
            for (int i = 0; i < fileList.size(); ++i) {
                metaFileList.add(fileList.get(i).toString());
            }
        }
        catch (Exception e) {
            logger.error("Error while fetching meta.json from path: {}", metas.get(0), (Object)e);
            return result;
        }
        if (metaFileList.isEmpty() && s3Listing.isEmpty()) {
            logger.info("Uncommon Scenario: Both meta file and backup filesystem listing is empty. Considering this as success");
            result.valid = true;
            return result;
        }
        result.filesInS3Only = new ArrayList<String>(s3Listing);
        result.filesInS3Only.removeAll(metaFileList);
        result.filesInMetaOnly = new ArrayList<String>(metaFileList);
        result.filesInMetaOnly.removeAll(s3Listing);
        result.filesMatched = (ArrayList)CollectionUtils.intersection(metaFileList, s3Listing);
        if (result.filesInMetaOnly.size() == 0) {
            result.valid = true;
        }
        return result;
    }
}

