/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.backup.parallel;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.netflix.priam.backup.AbstractBackup;
import com.netflix.priam.backup.AbstractBackupPath;
import com.netflix.priam.backup.BackupRestoreUtil;
import com.netflix.priam.backup.IFileSystemContext;
import com.netflix.priam.backup.IIncrementalBackup;
import com.netflix.priam.backup.IncrementalMetaData;
import com.netflix.priam.backup.parallel.ITaskQueueMgr;
import com.netflix.priam.backup.parallel.IncrementalConsumerMgr;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.scheduler.SimpleTimer;
import com.netflix.priam.scheduler.TaskTimer;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class IncrementalBackupProducer
extends AbstractBackup
implements IIncrementalBackup {
    public static final String JOBNAME = "ParallelIncremental";
    private static final Logger logger = LoggerFactory.getLogger(IncrementalBackupProducer.class);
    private final List<String> incrementalRemotePaths = new ArrayList<String>();
    private IncrementalMetaData metaData;
    private IncrementalConsumerMgr incrementalConsumerMgr;
    private ITaskQueueMgr<AbstractBackupPath> taskQueueMgr;
    private BackupRestoreUtil backupRestoreUtil;

    @Inject
    public IncrementalBackupProducer(IConfiguration config, Provider<AbstractBackupPath> pathFactory, IFileSystemContext backupFileSystemCtx, IncrementalMetaData metaData, @Named(value="backup") ITaskQueueMgr taskQueueMgr) {
        super(config, backupFileSystemCtx, pathFactory);
        this.taskQueueMgr = taskQueueMgr;
        this.metaData = metaData;
        this.init(backupFileSystemCtx);
    }

    private void init(IFileSystemContext backupFileSystemCtx) {
        this.backupRestoreUtil = new BackupRestoreUtil(this.config.getIncrementalKeyspaceFilters(), this.config.getIncrementalCFFilter());
        this.incrementalConsumerMgr = new IncrementalConsumerMgr(this.taskQueueMgr, backupFileSystemCtx.getFileStrategy(this.config), this.config);
        Thread consumerMgr = new Thread(this.incrementalConsumerMgr);
        consumerMgr.start();
    }

    @Override
    protected void processColumnFamily(String keyspace, String columnFamily, File backupDir) throws Exception {
        for (File file : backupDir.listFiles()) {
            try {
                AbstractBackupPath bp = (AbstractBackupPath)this.pathFactory.get();
                bp.parseLocal(file, AbstractBackupPath.BackupFileType.SST);
                this.taskQueueMgr.add(bp);
            }
            catch (Exception e) {
                logger.warn("Unable to queue incremental file, treating as non-fatal and moving on to next.  Msg: {} Fail to queue file: {}", (Object)e.getLocalizedMessage(), (Object)file.getAbsolutePath());
            }
        }
    }

    @Override
    protected void addToRemotePath(String remotePath) {
        this.incrementalRemotePaths.add(remotePath);
    }

    @Override
    public void execute() throws Exception {
        this.incrementalRemotePaths.clear();
        this.initiateBackup("backups", this.backupRestoreUtil);
    }

    public void postProcessing() {
    }

    @Override
    public String getName() {
        return JOBNAME;
    }

    @Override
    public long getNumPendingFiles() {
        throw new UnsupportedOperationException();
    }

    public static TaskTimer getTimer() {
        return new SimpleTimer(JOBNAME, 10000L);
    }

    @Override
    public String getJobName() {
        return JOBNAME;
    }
}

