/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.backup.parallel;

import com.netflix.priam.backup.AbstractBackupPath;
import com.netflix.priam.backup.IBackupFileSystem;
import com.netflix.priam.backup.parallel.BackupPostProcessingCallback;
import com.netflix.priam.backup.parallel.ITaskQueueMgr;
import com.netflix.priam.backup.parallel.IncrementalBkupPostProcessing;
import com.netflix.priam.backup.parallel.IncrementalConsumer;
import com.netflix.priam.config.IConfiguration;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalConsumerMgr
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(IncrementalConsumerMgr.class);
    private AtomicBoolean run = new AtomicBoolean(true);
    private ThreadPoolExecutor executor;
    private IBackupFileSystem fs;
    private ITaskQueueMgr<AbstractBackupPath> taskQueueMgr;
    private BackupPostProcessingCallback<AbstractBackupPath> callback;

    public IncrementalConsumerMgr(ITaskQueueMgr<AbstractBackupPath> taskQueueMgr, IBackupFileSystem fs, IConfiguration config) {
        this.taskQueueMgr = taskQueueMgr;
        this.fs = fs;
        int maxWorkers = config.getIncrementalBkupMaxConsumers();
        ArrayBlockingQueue<Runnable> workQueue = new ArrayBlockingQueue<Runnable>(config.getIncrementalBkupMaxConsumers() * 2);
        ThreadPoolExecutor.CallerRunsPolicy rejectedExecutionHandler = new ThreadPoolExecutor.CallerRunsPolicy();
        this.executor = new ThreadPoolExecutor(maxWorkers, maxWorkers, 60L, TimeUnit.SECONDS, workQueue, rejectedExecutionHandler);
        this.callback = new IncrementalBkupPostProcessing(this.taskQueueMgr);
    }

    public void shutdown() {
        this.run.set(false);
        this.executor.shutdown();
    }

    @Override
    public void run() {
        while (this.run.get()) {
            while (this.taskQueueMgr.hasTasks().booleanValue()) {
                try {
                    AbstractBackupPath bp = this.taskQueueMgr.take();
                    IncrementalConsumer task = new IncrementalConsumer(bp, this.fs, this.callback);
                    this.executor.submit(task);
                }
                catch (InterruptedException e) {
                    logger.warn("Was interrupted while wating to dequeued a task.  Msgl: {}", (Object)e.getLocalizedMessage());
                }
            }
            try {
                Thread.currentThread();
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                logger.warn("Was interrupted while sleeping until next interval run.  Msgl: {}", (Object)e.getLocalizedMessage());
            }
        }
    }
}

