/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.backupv2;

import com.netflix.priam.utils.DateUtil;
import com.netflix.priam.utils.GsonJsonSerializer;
import java.time.Instant;
import java.util.List;

public class MetaFileInfo {
    @GsonJsonSerializer.PriamAnnotation.GsonIgnore
    public static final String META_FILE_PREFIX = "meta_v2_";
    @GsonJsonSerializer.PriamAnnotation.GsonIgnore
    public static final String META_FILE_SUFFIX = ".json";
    @GsonJsonSerializer.PriamAnnotation.GsonIgnore
    public static final String META_FILE_INFO = "info";
    @GsonJsonSerializer.PriamAnnotation.GsonIgnore
    public static final String META_FILE_DATA = "data";
    private short version = 1;
    private String appName;
    private String region;
    private String rack;
    private List<String> backupIdentifier;

    public void setVersion(short version) {
        this.version = version;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setRack(String rack) {
        this.rack = rack;
    }

    public void setBackupIdentifier(List<String> backupIdentifier) {
        this.backupIdentifier = backupIdentifier;
    }

    public MetaFileInfo(String appName, String region, String rack, List<String> backupIdentifier) {
        this.appName = appName;
        this.region = region;
        this.rack = rack;
        this.backupIdentifier = backupIdentifier;
    }

    public short getVersion() {
        return this.version;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getRegion() {
        return this.region;
    }

    public String getRack() {
        return this.rack;
    }

    public List<String> getBackupIdentifier() {
        return this.backupIdentifier;
    }

    public String toString() {
        return GsonJsonSerializer.getGson().toJson((Object)this);
    }

    public static String getMetaFileName(Instant instant) {
        return META_FILE_PREFIX + DateUtil.formatInstant("yyyyMMddHHmm", instant) + META_FILE_SUFFIX;
    }
}

