/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.cluster.management;

import com.netflix.priam.cluster.management.IClusterManagement;
import com.netflix.priam.cluster.management.SchemaConstant;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.defaultimpl.CassandraOperations;
import com.netflix.priam.merics.CompactionMeasurement;
import com.netflix.priam.scheduler.CronTimer;
import com.netflix.priam.scheduler.TaskTimer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Compaction
extends IClusterManagement<String> {
    private static final Logger logger = LoggerFactory.getLogger(Compaction.class);
    private final IConfiguration config;
    private static final Pattern columnFamilyFilterPattern = Pattern.compile(".\\..");
    private final CassandraOperations cassandraOperations;

    @Inject
    public Compaction(IConfiguration config, CassandraOperations cassandraOperations, CompactionMeasurement compactionMeasurement) {
        super(config, IClusterManagement.Task.COMPACTION, compactionMeasurement);
        this.config = config;
        this.cassandraOperations = cassandraOperations;
    }

    private final Map<String, List<String>> getCompactionFilter(String compactionFilter) throws IllegalArgumentException {
        if (StringUtils.isEmpty((CharSequence)compactionFilter)) {
            return null;
        }
        HashMap<String, List<String>> columnFamilyFilter = new HashMap<String, List<String>>();
        String[] filters = compactionFilter.split(",");
        for (int i = 0; i < filters.length; ++i) {
            List existingCfs;
            String keyspaceName;
            if (columnFamilyFilterPattern.matcher(filters[i]).find()) {
                String[] filter = filters[i].split("\\.");
                keyspaceName = filter[0];
                String columnFamilyName = filter[1];
                if (columnFamilyName.indexOf("-") != -1) {
                    columnFamilyName = columnFamilyName.substring(0, columnFamilyName.indexOf("-"));
                }
                existingCfs = columnFamilyFilter.getOrDefault(keyspaceName, new ArrayList());
                if (!columnFamilyName.equalsIgnoreCase("*")) {
                    existingCfs.add(columnFamilyName);
                }
            } else {
                throw new IllegalArgumentException("Column family filter format is not valid.  Format needs to be \"keyspace.columnfamily\".  Invalid input: " + filters[i]);
            }
            columnFamilyFilter.put(keyspaceName, existingCfs);
        }
        return columnFamilyFilter;
    }

    final Map<String, List<String>> getCompactionIncludeFilter(IConfiguration config) throws Exception {
        if (StringUtils.isEmpty((CharSequence)config.getCompactionIncludeCFList())) {
            return null;
        }
        Map<String, List<String>> columnFamilyFilter = this.getCompactionFilter(config.getCompactionIncludeCFList());
        logger.info("Compaction: Override for include CF provided by user: {}", columnFamilyFilter);
        return columnFamilyFilter;
    }

    final Map<String, List<String>> getCompactionExcludeFilter(IConfiguration config) throws Exception {
        if (StringUtils.isEmpty((CharSequence)config.getCompactionExcludeCFList())) {
            return null;
        }
        Map<String, List<String>> columnFamilyFilter = this.getCompactionFilter(config.getCompactionExcludeCFList());
        logger.info("Compaction: Override for exclude CF provided by user: {}", columnFamilyFilter);
        return columnFamilyFilter;
    }

    final Map<String, List<String>> getCompactionFilterCfs(IConfiguration config) throws Exception {
        Map<String, List<String>> includeFilter = this.getCompactionIncludeFilter(config);
        Map<String, List<String>> excludeFilter = this.getCompactionExcludeFilter(config);
        Map<String, List<String>> allColumnfamilies = this.cassandraOperations.getColumnfamilies();
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        allColumnfamilies.entrySet().forEach(entry -> {
            String keyspaceName = (String)entry.getKey();
            if (SchemaConstant.isSystemKeyspace(keyspaceName)) {
                return;
            }
            List columnfamilies = (List)entry.getValue();
            if (excludeFilter != null && excludeFilter.containsKey(keyspaceName)) {
                List excludeCFFilter = (List)excludeFilter.get(keyspaceName);
                if (excludeCFFilter == null || excludeCFFilter.isEmpty()) {
                    return;
                }
                columnfamilies = (List)CollectionUtils.removeAll((Collection)columnfamilies, (Collection)excludeCFFilter);
            }
            if (includeFilter != null) {
                if (!includeFilter.containsKey(keyspaceName)) {
                    return;
                }
                List includeCFFilter = (List)includeFilter.get(keyspaceName);
                if (includeCFFilter != null && !includeCFFilter.isEmpty()) {
                    columnfamilies = (List)CollectionUtils.intersection((Iterable)columnfamilies, (Iterable)includeCFFilter);
                }
            }
            if (columnfamilies != null && !columnfamilies.isEmpty()) {
                result.put(keyspaceName, columnfamilies);
            }
        });
        return result;
    }

    @Override
    protected String runTask() throws Exception {
        Map<String, List<String>> columnfamilies = this.getCompactionFilterCfs(this.config);
        if (!columnfamilies.isEmpty()) {
            for (Map.Entry<String, List<String>> entry : columnfamilies.entrySet()) {
                this.cassandraOperations.forceKeyspaceCompaction(entry.getKey(), entry.getValue().toArray(new String[0]));
            }
        }
        return columnfamilies.toString();
    }

    public static TaskTimer getTimer(IConfiguration config) throws Exception {
        return CronTimer.getCronTimer(IClusterManagement.Task.COMPACTION.name(), config.getCompactionCronExpression());
    }
}

