/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.cluster.management;

import com.netflix.priam.cluster.management.IClusterManagement;
import com.netflix.priam.cluster.management.SchemaConstant;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.defaultimpl.CassandraOperations;
import com.netflix.priam.merics.NodeToolFlushMeasurement;
import com.netflix.priam.scheduler.CronTimer;
import com.netflix.priam.scheduler.TaskTimer;
import com.netflix.priam.scheduler.UnsupportedTypeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Flush
extends IClusterManagement<String> {
    private static final Logger logger = LoggerFactory.getLogger(Flush.class);
    private final IConfiguration config;
    private final CassandraOperations cassandraOperations;
    private List<String> keyspaces = new ArrayList<String>();

    @Inject
    public Flush(IConfiguration config, CassandraOperations cassandraOperations, NodeToolFlushMeasurement nodeToolFlushMeasurement) {
        super(config, IClusterManagement.Task.FLUSH, nodeToolFlushMeasurement);
        this.config = config;
        this.cassandraOperations = cassandraOperations;
    }

    @Override
    protected String runTask() throws Exception {
        ArrayList<String> flushed = new ArrayList<String>();
        this.deriveKeyspaces();
        if (this.keyspaces == null || this.keyspaces.isEmpty()) {
            logger.warn("NO op on requested \"flush\" as there are no keyspaces.");
            return ((Object)flushed).toString();
        }
        for (String keyspace : this.keyspaces) {
            if (!this.cassandraOperations.getKeyspaces().contains(keyspace)) {
                throw new IllegalArgumentException("Keyspace [" + keyspace + "] does not exist.");
            }
            if (SchemaConstant.isSystemKeyspace(keyspace)) continue;
            try {
                this.cassandraOperations.forceKeyspaceFlush(keyspace);
                flushed.add(keyspace);
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                throw new Exception("Exception during flushing keyspace: " + keyspace, e);
            }
        }
        return ((Object)flushed).toString();
    }

    private void deriveKeyspaces() throws Exception {
        String raw = this.config.getFlushKeyspaces();
        if (raw != null && !raw.isEmpty()) {
            String[] k = raw.split(",");
            for (int i = 0; i < k.length; ++i) {
                this.keyspaces.add(i, k[i]);
            }
            return;
        }
        this.keyspaces = this.cassandraOperations.getKeyspaces();
    }

    public static TaskTimer getTimer(IConfiguration config) throws Exception {
        CronTimer cronTimer = null;
        block0 : switch (config.getFlushSchedulerType()) {
            case HOUR: {
                String timerVal = config.getFlushInterval();
                if (timerVal == null) {
                    return null;
                }
                String[] s = timerVal.split("=");
                if (s.length != 2) {
                    throw new IllegalArgumentException("Flush interval format is invalid.  Expecting name=value, received: " + timerVal);
                }
                String name = s[0].toUpperCase();
                Integer time = new Integer(s[1]);
                switch (name) {
                    case "HOUR": {
                        cronTimer = new CronTimer(IClusterManagement.Task.FLUSH.name(), time, 0);
                        break block0;
                    }
                    case "DAILY": {
                        cronTimer = new CronTimer(IClusterManagement.Task.FLUSH.name(), time, 0, 0);
                        break block0;
                    }
                }
                throw new UnsupportedTypeException("Flush interval type is invalid.  Expecting \"hour, daily\", received: " + name);
            }
            case CRON: {
                cronTimer = CronTimer.getCronTimer(IClusterManagement.Task.FLUSH.name(), config.getFlushCronExpression());
            }
        }
        return cronTimer;
    }
}

