/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.cred;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.netflix.priam.cred.ICredential;
import java.io.Closeable;
import java.io.FileInputStream;
import java.util.Properties;
import org.apache.cassandra.io.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClearCredential
implements ICredential {
    private static final Logger logger = LoggerFactory.getLogger(ClearCredential.class);
    private static final String CRED_FILE = "/etc/awscredential.properties";
    private final String AWS_ACCESS_ID;
    private final String AWS_KEY;

    public ClearCredential() {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(CRED_FILE);
            Properties props = new Properties();
            props.load(fis);
            this.AWS_ACCESS_ID = props.getProperty("AWSACCESSID") != null ? props.getProperty("AWSACCESSID").trim() : "";
            this.AWS_KEY = props.getProperty("AWSKEY") != null ? props.getProperty("AWSKEY").trim() : "";
        }
        catch (Exception e) {
            try {
                logger.error("Exception with credential file ", (Throwable)e);
                throw new RuntimeException("Problem reading credential file. Cannot start.", e);
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(fis);
                throw throwable;
            }
        }
        FileUtils.closeQuietly((Closeable)fis);
    }

    @Override
    public AWSCredentialsProvider getAwsCredentialProvider() {
        return new AWSCredentialsProvider(){

            public AWSCredentials getCredentials() {
                return new BasicAWSCredentials(ClearCredential.this.AWS_ACCESS_ID, ClearCredential.this.AWS_KEY);
            }

            public void refresh() {
            }
        };
    }
}

