/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.health;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.netflix.priam.backup.BackupMetadata;
import com.netflix.priam.backup.Status;
import com.netflix.priam.utils.GsonJsonSerializer;
import java.time.LocalDateTime;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class InstanceState {
    private static final Logger logger = LoggerFactory.getLogger(InstanceState.class);
    private final AtomicBoolean isBootstrapping = new AtomicBoolean(false);
    private NODE_STATE nodeState;
    private LocalDateTime bootstrapTime;
    private final AtomicBoolean isCassandraProcessAlive = new AtomicBoolean(false);
    private final AtomicBoolean shouldCassandraBeAlive = new AtomicBoolean(false);
    private final AtomicLong lastAttemptedStartTime = new AtomicLong(Long.MAX_VALUE);
    private final AtomicBoolean isGossipActive = new AtomicBoolean(false);
    private final AtomicBoolean isNativeTransportActive = new AtomicBoolean(false);
    private final AtomicBoolean isRequiredDirectoriesExist = new AtomicBoolean(false);
    private final AtomicBoolean isYmlWritten = new AtomicBoolean(false);
    private final AtomicBoolean isHealthy = new AtomicBoolean(false);
    private final AtomicBoolean isHealthyOverride = new AtomicBoolean(true);
    private BackupMetadata backupStatus;
    private RestoreStatus restoreStatus;

    @Inject
    InstanceState(RestoreStatus restoreStatus) {
        this.restoreStatus = restoreStatus;
    }

    public String toString() {
        return GsonJsonSerializer.getGson().toJson((Object)this);
    }

    public boolean isGossipActive() {
        return this.isGossipActive.get();
    }

    public void setIsGossipActive(boolean isGossipActive) {
        this.isGossipActive.set(isGossipActive);
        this.setHealthy();
    }

    public boolean isNativeTransportActive() {
        return this.isNativeTransportActive.get();
    }

    public void setIsNativeTransportActive(boolean isNativeTransportActive) {
        this.isNativeTransportActive.set(isNativeTransportActive);
        this.setHealthy();
    }

    public boolean isRequiredDirectoriesExist() {
        return this.isRequiredDirectoriesExist.get();
    }

    public void setIsRequiredDirectoriesExist(boolean isRequiredDirectoriesExist) {
        this.isRequiredDirectoriesExist.set(isRequiredDirectoriesExist);
        this.setHealthy();
    }

    public boolean isCassandraProcessAlive() {
        return this.isCassandraProcessAlive.get();
    }

    public void setCassandraProcessAlive(boolean isSideCarProcessAlive) {
        this.isCassandraProcessAlive.set(isSideCarProcessAlive);
        this.setHealthy();
    }

    public boolean shouldCassandraBeAlive() {
        return this.shouldCassandraBeAlive.get();
    }

    public void setShouldCassandraBeAlive(boolean shouldCassandraBeAlive) {
        this.shouldCassandraBeAlive.set(shouldCassandraBeAlive);
        this.setIsHealthyOverride(shouldCassandraBeAlive);
    }

    public void setIsHealthyOverride(boolean isHealthyOverride) {
        this.isHealthyOverride.set(isHealthyOverride);
    }

    public boolean isHealthyOverride() {
        return this.isHealthyOverride.get();
    }

    public void markLastAttemptedStartTime() {
        this.lastAttemptedStartTime.set(System.currentTimeMillis());
    }

    public long getLastAttemptedStartTime() {
        return this.lastAttemptedStartTime.get();
    }

    public boolean isBootstrapping() {
        return this.isBootstrapping.get();
    }

    public void setBootstrapping(boolean isBootstrapping) {
        this.isBootstrapping.set(isBootstrapping);
    }

    public NODE_STATE getNodeState() {
        return this.nodeState;
    }

    public LocalDateTime getBootstrapTime() {
        return this.bootstrapTime;
    }

    public void setBootstrapTime(LocalDateTime bootstrapTime) {
        this.bootstrapTime = bootstrapTime;
    }

    public void setNodeState(NODE_STATE nodeState) {
        this.nodeState = nodeState;
    }

    public BackupMetadata getBackupStatus() {
        return this.backupStatus;
    }

    public void setBackupStatus(BackupMetadata backupMetadata) {
        this.backupStatus = backupMetadata;
    }

    public RestoreStatus getRestoreStatus() {
        return this.restoreStatus;
    }

    public void setRestoreStatus(Status status) {
        this.restoreStatus.status = status;
        this.setHealthy();
    }

    public boolean isHealthy() {
        return this.isHealthy.get();
    }

    private boolean isRestoring() {
        return this.restoreStatus != null && this.restoreStatus.getStatus() != null && this.restoreStatus.getStatus() == Status.STARTED;
    }

    private void setHealthy() {
        this.isHealthy.set(this.isRestoring() || this.isCassandraProcessAlive() && this.isRequiredDirectoriesExist() && this.isGossipActive() && this.isYmlWritten() && this.isHealthyOverride() && this.isNativeTransportActive());
    }

    public boolean isYmlWritten() {
        return this.isYmlWritten.get();
    }

    public void setYmlWritten(boolean yml) {
        this.isYmlWritten.set(yml);
    }

    public static class RestoreStatus {
        private LocalDateTime startDateRange;
        private LocalDateTime endDateRange;
        private LocalDateTime executionStartTime;
        private LocalDateTime executionEndTime;
        private String snapshotMetaFile;
        private Status status;

        public void resetStatus() {
            this.snapshotMetaFile = null;
            this.status = null;
            this.endDateRange = null;
            this.startDateRange = null;
            this.executionEndTime = null;
            this.executionStartTime = null;
        }

        public String toString() {
            return GsonJsonSerializer.getGson().toJson((Object)this);
        }

        public Status getStatus() {
            return this.status;
        }

        public void setStartDateRange(LocalDateTime startDateRange) {
            this.startDateRange = startDateRange;
        }

        public void setEndDateRange(LocalDateTime endDateRange) {
            this.endDateRange = endDateRange;
        }

        public void setExecutionStartTime(LocalDateTime executionStartTime) {
            this.executionStartTime = executionStartTime;
        }

        public void setExecutionEndTime(LocalDateTime executionEndTime) {
            this.executionEndTime = executionEndTime;
        }

        public LocalDateTime getStartDateRange() {
            return this.startDateRange;
        }

        public LocalDateTime getEndDateRange() {
            return this.endDateRange;
        }

        public LocalDateTime getExecutionStartTime() {
            return this.executionStartTime;
        }

        public LocalDateTime getExecutionEndTime() {
            return this.executionEndTime;
        }

        public String getSnapshotMetaFile() {
            return this.snapshotMetaFile;
        }

        public void setSnapshotMetaFile(String snapshotMetaFile) {
            this.snapshotMetaFile = snapshotMetaFile;
        }
    }

    public static enum NODE_STATE {
        JOIN,
        REPLACE;

    }
}

