/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.identity.config;

import com.netflix.priam.identity.config.InstanceDataRetrieverBase;
import com.netflix.priam.utils.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AWSVpcInstanceDataRetriever
extends InstanceDataRetrieverBase {
    private static final Logger logger = LoggerFactory.getLogger(AWSVpcInstanceDataRetriever.class);

    @Override
    public String getVpcId() {
        String nacId = this.getMac();
        if (nacId == null || nacId.isEmpty()) {
            return null;
        }
        String vpcId = null;
        try {
            vpcId = SystemUtils.getDataFromUrl("http://169.254.169.254/latest/meta-data/network/interfaces/macs/" + nacId + "vpc-id").trim();
        }
        catch (Exception e) {
            logger.info("Vpc id does not exist for running instance, not fatal as running instance maybe not be in vpc.  Msg: {}", (Object)e.getLocalizedMessage());
        }
        return vpcId;
    }

    @Override
    public String getPublicHostname() {
        try {
            return SystemUtils.getDataFromUrl("http://169.254.169.254/latest/meta-data/public-hostname");
        }
        catch (RuntimeException error) {
            return SystemUtils.getDataFromUrl("http://169.254.169.254/latest/meta-data/local-hostname");
        }
    }

    @Override
    public String getPublicIP() {
        try {
            return SystemUtils.getDataFromUrl("http://169.254.169.254/latest/meta-data/public-ipv4");
        }
        catch (RuntimeException error) {
            return SystemUtils.getDataFromUrl("http://169.254.169.254/latest/meta-data/local-ipv4");
        }
    }
}

