/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.identity.token;

import com.google.common.collect.ListMultimap;
import com.google.inject.Inject;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.identity.IMembership;
import com.netflix.priam.identity.IPriamInstanceFactory;
import com.netflix.priam.identity.InstanceEnvIdentity;
import com.netflix.priam.identity.PriamInstance;
import com.netflix.priam.identity.token.IDeadTokenRetriever;
import com.netflix.priam.identity.token.TokenRetrieverBase;
import com.netflix.priam.utils.Sleeper;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeadTokenRetriever
extends TokenRetrieverBase
implements IDeadTokenRetriever {
    private static final Logger logger = LoggerFactory.getLogger(DeadTokenRetriever.class);
    private IPriamInstanceFactory factory;
    private IMembership membership;
    private IConfiguration config;
    private Sleeper sleeper;
    private String replacedIp;
    private ListMultimap<String, PriamInstance> locMap;
    private InstanceEnvIdentity insEnvIdentity;

    @Inject
    public DeadTokenRetriever(IPriamInstanceFactory factory, IMembership membership, IConfiguration config, Sleeper sleeper, InstanceEnvIdentity insEnvIdentity) {
        this.factory = factory;
        this.membership = membership;
        this.config = config;
        this.sleeper = sleeper;
        this.insEnvIdentity = insEnvIdentity;
    }

    private List<String> getDualAccountRacMembership(List<String> asgInstances) {
        logger.info("Dual Account cluster");
        List<String> crossAccountAsgInstances = this.membership.getCrossAccountRacMembership();
        if (logger.isInfoEnabled()) {
            if (this.insEnvIdentity.isClassic().booleanValue()) {
                logger.info("EC2 classic instances (local ASG): " + Arrays.toString(asgInstances.toArray()));
                logger.info("VPC Account (cross-account ASG): " + Arrays.toString(crossAccountAsgInstances.toArray()));
            } else {
                logger.info("VPC Account (local ASG): " + Arrays.toString(asgInstances.toArray()));
                logger.info("EC2 classic instances (cross-account ASG): " + Arrays.toString(crossAccountAsgInstances.toArray()));
            }
        }
        asgInstances.removeAll(crossAccountAsgInstances);
        asgInstances.addAll(crossAccountAsgInstances);
        logger.info("Combined Instances in the AZ: {}", asgInstances);
        return asgInstances;
    }

    @Override
    public PriamInstance get() throws Exception {
        logger.info("Looking for a token from any dead node");
        List<PriamInstance> allIds = this.factory.getAllIds(this.config.getAppName());
        List<String> asgInstances = this.membership.getRacMembership();
        if (this.config.isDualAccount()) {
            asgInstances = this.getDualAccountRacMembership(asgInstances);
        } else {
            logger.info("Single Account cluster");
        }
        this.sleeper.sleep(new Random().nextInt(5000) + 10000);
        for (PriamInstance dead : allIds) {
            if (!dead.getRac().equals(this.config.getRac()) || asgInstances.contains(dead.getInstanceId()) || super.isInstanceDummy(dead)) continue;
            logger.info("Found dead instances: {}", (Object)dead.getInstanceId());
            PriamInstance markAsDead = this.factory.create(dead.getApp() + "-dead", dead.getId(), dead.getInstanceId(), dead.getHostName(), dead.getHostIP(), dead.getRac(), dead.getVolumes(), dead.getToken());
            this.factory.delete(dead);
            this.replacedIp = this.findReplaceIp(allIds, markAsDead.getToken(), markAsDead.getDC());
            if (this.replacedIp == null) {
                this.replacedIp = markAsDead.getHostIP();
            }
            String payLoad = markAsDead.getToken();
            logger.info("Trying to grab slot {} with availability zone {}", (Object)markAsDead.getId(), (Object)markAsDead.getRac());
            return this.factory.create(this.config.getAppName(), markAsDead.getId(), this.config.getInstanceName(), this.config.getHostname(), this.config.getHostIP(), this.config.getRac(), markAsDead.getVolumes(), payLoad);
        }
        return null;
    }

    @Override
    public String getReplaceIp() {
        return this.replacedIp;
    }

    private String findReplaceIp(List<PriamInstance> allIds, String token, String location) {
        String ip = null;
        for (PriamInstance ins : allIds) {
            logger.info("Calling getIp on hostname[{}] and token[{}]", (Object)ins.getHostName(), (Object)token);
            if (ins.getToken().equals(token) || !ins.getDC().equals(location)) continue;
            try {
                ip = this.getIp(ins.getHostName(), token);
            }
            catch (ParseException e) {
                ip = null;
            }
            if (ip == null) continue;
            logger.info("Found the IP: {}", (Object)ip);
            return ip;
        }
        return null;
    }

    private String getIp(String host, String token) throws ParseException {
        DefaultClientConfig config = new DefaultClientConfig();
        Client client = Client.create((ClientConfig)config);
        String baseURI = this.getBaseURI(host);
        WebResource service = client.resource(baseURI);
        String textEntity = null;
        try {
            ClientResponse clientResp = (ClientResponse)service.path("Priam/REST/v1/cassadmin/gossipinfo").accept(new String[]{"application/json"}).get(ClientResponse.class);
            if (clientResp.getStatus() != 200) {
                return null;
            }
            textEntity = (String)clientResp.getEntity(String.class);
            logger.info("Respond from calling gossipinfo on host[{}] and token[{}] : {}", new Object[]{host, token, textEntity});
            if (StringUtils.isEmpty((CharSequence)textEntity)) {
                return null;
            }
        }
        catch (Exception e) {
            logger.info("Error in reaching out to host: {}", (Object)baseURI);
            return null;
        }
        JSONParser parser = new JSONParser();
        Object obj = parser.parse(textEntity);
        JSONObject jsonObject = (JSONObject)obj;
        for (Object key : jsonObject.keySet()) {
            String tokenVal;
            JSONObject msg = (JSONObject)jsonObject.get(key);
            if (msg.get((Object)"Token") == null || !token.equals(tokenVal = (String)msg.get((Object)"Token"))) continue;
            logger.info("Using gossipinfo from host[{}] and token[{}], the replaced address is : {}", new Object[]{host, token, key});
            return (String)key;
        }
        return null;
    }

    private String getBaseURI(String host) {
        return "http://" + host + ":8080/";
    }

    @Override
    public void setLocMap(ListMultimap<String, PriamInstance> locMap) {
        this.locMap = locMap;
    }
}

