/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.identity.token;

import com.google.common.collect.ListMultimap;
import com.google.inject.Inject;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.identity.IMembership;
import com.netflix.priam.identity.IPriamInstanceFactory;
import com.netflix.priam.identity.PriamInstance;
import com.netflix.priam.identity.token.IPreGeneratedTokenRetriever;
import com.netflix.priam.identity.token.TokenRetrieverBase;
import com.netflix.priam.utils.Sleeper;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreGeneratedTokenRetriever
extends TokenRetrieverBase
implements IPreGeneratedTokenRetriever {
    private static final Logger logger = LoggerFactory.getLogger(PreGeneratedTokenRetriever.class);
    private IPriamInstanceFactory factory;
    private IMembership membership;
    private IConfiguration config;
    private Sleeper sleeper;
    private ListMultimap<String, PriamInstance> locMap;

    @Inject
    public PreGeneratedTokenRetriever(IPriamInstanceFactory factory, IMembership membership, IConfiguration config, Sleeper sleeper) {
        this.factory = factory;
        this.membership = membership;
        this.config = config;
        this.sleeper = sleeper;
    }

    @Override
    public PriamInstance get() throws Exception {
        logger.info("Looking for any pre-generated token");
        List allIds = this.factory.getAllIds(this.config.getAppName());
        List<String> asgInstances = this.membership.getRacMembership();
        this.sleeper.sleep(new Random().nextInt(5000) + 10000);
        for (PriamInstance dead : allIds) {
            if (!dead.getRac().equals(this.config.getRac()) || asgInstances.contains(dead.getInstanceId()) || !this.isInstanceDummy(dead)) continue;
            logger.info("Found pre-generated token: {}", (Object)dead.getToken());
            PriamInstance markAsDead = this.factory.create(dead.getApp() + "-dead", dead.getId(), dead.getInstanceId(), dead.getHostName(), dead.getHostIP(), dead.getRac(), dead.getVolumes(), dead.getToken());
            this.factory.delete(dead);
            String payLoad = markAsDead.getToken();
            logger.info("Trying to grab slot {} with availability zone {}", (Object)markAsDead.getId(), (Object)markAsDead.getRac());
            return this.factory.create(this.config.getAppName(), markAsDead.getId(), this.config.getInstanceName(), this.config.getHostname(), this.config.getHostIP(), this.config.getRac(), markAsDead.getVolumes(), payLoad);
        }
        return null;
    }

    @Override
    public void setLocMap(ListMultimap<String, PriamInstance> locMap) {
        this.locMap = locMap;
    }
}

