/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.notification;

import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.AmazonSNSClient;
import com.amazonaws.services.sns.AmazonSNSClientBuilder;
import com.amazonaws.services.sns.model.MessageAttributeValue;
import com.amazonaws.services.sns.model.PublishRequest;
import com.amazonaws.services.sns.model.PublishResult;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.netflix.priam.aws.IAMCredential;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.merics.BackupMetrics;
import com.netflix.priam.notification.INotificationService;
import com.netflix.priam.utils.BoundedExponentialRetryCallable;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AWSSnsNotificationService
implements INotificationService {
    private static final Logger logger = LoggerFactory.getLogger(AWSSnsNotificationService.class);
    private IConfiguration configuration;
    private AmazonSNS snsClient;
    private BackupMetrics backupMetrics;

    @Inject
    public AWSSnsNotificationService(IConfiguration config, IAMCredential iamCredential, BackupMetrics backupMetrics) {
        this.configuration = config;
        this.backupMetrics = backupMetrics;
        String ec2_region = this.configuration.getDC();
        this.snsClient = (AmazonSNS)((AmazonSNSClientBuilder)((AmazonSNSClientBuilder)AmazonSNSClient.builder().withCredentials(iamCredential.getAwsCredentialProvider())).withRegion(ec2_region)).build();
    }

    @Override
    public void notify(final String msg, final Map<String, MessageAttributeValue> messageAttributes) {
        final String topic_arn = this.configuration.getBackupNotificationTopicArn();
        if (StringUtils.isEmpty((CharSequence)topic_arn)) {
            return;
        }
        PublishResult publishResult = null;
        try {
            publishResult = (PublishResult)new BoundedExponentialRetryCallable<PublishResult>(){

                @Override
                public PublishResult retriableCall() throws Exception {
                    PublishRequest publishRequest = new PublishRequest(topic_arn, msg).withMessageAttributes(messageAttributes);
                    PublishResult result = AWSSnsNotificationService.this.snsClient.publish(publishRequest);
                    return result;
                }
            }.call();
        }
        catch (Exception e) {
            logger.error(String.format("Exhausted retries.  Publishing notification metric for failure and moving on.  Failed msg to publish: {}", msg), (Throwable)e);
            this.backupMetrics.incrementSnsNotificationFailure();
            return;
        }
        String publishedMsgId = publishResult.getMessageId();
        if (publishedMsgId == null || publishedMsgId.isEmpty()) {
            this.backupMetrics.incrementSnsNotificationFailure();
            return;
        }
        this.backupMetrics.incrementSnsNotificationSuccess();
        if (logger.isTraceEnabled()) {
            logger.trace("Published msg:  {} aws sns messageId - {}", (Object)msg, (Object)publishedMsgId);
        }
    }
}

