/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.resources;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.netflix.priam.cluster.management.Compaction;
import com.netflix.priam.cluster.management.Flush;
import com.netflix.priam.compress.SnappyCompression;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.defaultimpl.ICassandraProcess;
import com.netflix.priam.utils.JMXConnectionException;
import com.netflix.priam.utils.JMXNodeTool;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/cassadmin")
@Produces(value={"application/json"})
public class CassandraAdmin {
    private static final String REST_HEADER_KEYSPACES = "keyspaces";
    private static final String REST_HEADER_CFS = "cfnames";
    private static final String REST_HEADER_TOKEN = "token";
    private static final String REST_SUCCESS = "[\"ok\"]";
    private static final Logger logger = LoggerFactory.getLogger(CassandraAdmin.class);
    private final IConfiguration config;
    private final ICassandraProcess cassProcess;
    private final Flush flush;
    private final Compaction compaction;

    @Inject
    public CassandraAdmin(IConfiguration config, ICassandraProcess cassProcess, Flush flush, Compaction compaction) {
        this.config = config;
        this.cassProcess = cassProcess;
        this.flush = flush;
        this.compaction = compaction;
    }

    @GET
    @Path(value="/start")
    public Response cassStart() throws IOException, InterruptedException, JSONException {
        this.cassProcess.start(true);
        return Response.ok((Object)REST_SUCCESS, (String)"application/json").build();
    }

    @GET
    @Path(value="/stop")
    public Response cassStop(@DefaultValue(value="false") @QueryParam(value="force") boolean force) throws IOException, InterruptedException, JSONException {
        this.cassProcess.stop(force);
        return Response.ok((Object)REST_SUCCESS, (String)"application/json").build();
    }

    @GET
    @Path(value="/refresh")
    public Response cassRefresh(@QueryParam(value="keyspaces") String keyspaces) throws IOException, ExecutionException, InterruptedException, JSONException {
        JMXNodeTool nodeTool;
        logger.debug("node tool refresh is being called");
        if (StringUtils.isBlank((CharSequence)keyspaces)) {
            return Response.status((int)400).entity((Object)"Missing keyspace in request").build();
        }
        try {
            nodeTool = JMXNodeTool.instance(this.config);
        }
        catch (JMXConnectionException e) {
            logger.error("Exception in fetching c* jmx tool .  Msgl: {}", (Object)e.getLocalizedMessage(), (Object)e);
            return Response.status((int)503).entity((Object)"JMXConnectionException").build();
        }
        nodeTool.refresh(Lists.newArrayList((Object[])keyspaces.split(",")));
        return Response.ok((Object)REST_SUCCESS, (String)"application/json").build();
    }

    @GET
    @Path(value="/info")
    public Response cassInfo() throws IOException, InterruptedException, JSONException {
        JMXNodeTool nodeTool;
        try {
            nodeTool = JMXNodeTool.instance(this.config);
        }
        catch (JMXConnectionException e) {
            logger.error("Exception in fetching c* jmx tool .  Msgl: {}", (Object)e.getLocalizedMessage(), (Object)e);
            return Response.status((int)503).entity((Object)"JMXConnectionException").build();
        }
        logger.debug("node tool info being called");
        return Response.ok((Object)nodeTool.info(), (String)"application/json").build();
    }

    @GET
    @Path(value="/partitioner")
    public Response cassPartitioner() throws IOException, InterruptedException, JSONException {
        JMXNodeTool nodeTool;
        try {
            nodeTool = JMXNodeTool.instance(this.config);
        }
        catch (JMXConnectionException e) {
            logger.error("Exception in fetching c* jmx tool .  Msgl: {}", (Object)e.getLocalizedMessage(), (Object)e);
            return Response.status((int)503).entity((Object)"JMXConnectionException").build();
        }
        logger.debug("node tool getPartitioner being called");
        return Response.ok((Object)nodeTool.getPartitioner(), (String)"application/json").build();
    }

    @GET
    @Path(value="/ring/{id}")
    public Response cassRing(@PathParam(value="id") String keyspace) throws IOException, InterruptedException, JSONException {
        JMXNodeTool nodeTool;
        try {
            nodeTool = JMXNodeTool.instance(this.config);
        }
        catch (JMXConnectionException e) {
            logger.error("Exception in fetching c* jmx tool .  Msgl: {}", (Object)e.getLocalizedMessage(), (Object)e);
            return Response.status((int)503).entity((Object)"JMXConnectionException").build();
        }
        logger.debug("node tool ring being called");
        return Response.ok((Object)nodeTool.ring(keyspace), (String)"application/json").build();
    }

    @GET
    @Path(value="/flush")
    public Response cassFlush() throws IOException, InterruptedException, ExecutionException {
        JSONObject rootObj = new JSONObject();
        try {
            this.flush.execute();
            rootObj.put("Flushed", true);
            return Response.ok().entity((Object)rootObj).build();
        }
        catch (Exception e) {
            try {
                rootObj.put("status", (Object)"ERRROR");
                rootObj.put("desc", (Object)e.getLocalizedMessage());
            }
            catch (Exception e1) {
                return Response.status((int)503).entity((Object)"FlushError").build();
            }
            return Response.status((int)503).entity((Object)rootObj).build();
        }
    }

    @GET
    @Path(value="/compact")
    public Response cassCompact() throws IOException, ExecutionException, InterruptedException {
        JSONObject rootObj = new JSONObject();
        try {
            this.compaction.execute();
            rootObj.put("Compcated", true);
            return Response.ok().entity((Object)rootObj).build();
        }
        catch (Exception e) {
            try {
                rootObj.put("status", (Object)"ERRROR");
                rootObj.put("desc", (Object)e.getLocalizedMessage());
            }
            catch (Exception e1) {
                return Response.status((int)503).entity((Object)"CompactionError").build();
            }
            return Response.status((int)503).entity((Object)rootObj).build();
        }
    }

    @GET
    @Path(value="/cleanup")
    public Response cassCleanup() throws IOException, ExecutionException, InterruptedException {
        JMXNodeTool nodeTool;
        try {
            nodeTool = JMXNodeTool.instance(this.config);
        }
        catch (JMXConnectionException e) {
            logger.error("Exception in fetching c* jmx tool .  Msgl: {}", (Object)e.getLocalizedMessage(), (Object)e);
            return Response.status((int)503).entity((Object)"JMXConnectionException").build();
        }
        logger.debug("node tool cleanup being called");
        nodeTool.cleanup();
        return Response.ok().build();
    }

    @GET
    @Path(value="/repair")
    public Response cassRepair(@QueryParam(value="sequential") boolean isSequential, @QueryParam(value="localDC") boolean localDCOnly, @DefaultValue(value="false") @QueryParam(value="primaryRange") boolean primaryRange) throws IOException, ExecutionException, InterruptedException {
        JMXNodeTool nodeTool;
        try {
            nodeTool = JMXNodeTool.instance(this.config);
        }
        catch (JMXConnectionException e) {
            logger.error("Exception in fetching c* jmx tool .  Msgl: {}", (Object)e.getLocalizedMessage(), (Object)e);
            return Response.status((int)503).entity((Object)"JMXConnectionException").build();
        }
        logger.debug("node tool repair being called");
        nodeTool.repair(isSequential, localDCOnly, primaryRange);
        return Response.ok((Object)REST_SUCCESS, (String)"application/json").build();
    }

    @GET
    @Path(value="/version")
    public Response version() throws IOException, ExecutionException, InterruptedException {
        JMXNodeTool nodeTool;
        try {
            nodeTool = JMXNodeTool.instance(this.config);
        }
        catch (JMXConnectionException e) {
            logger.error("Exception in fetching c* jmx tool .  Msgl: {}", (Object)e.getLocalizedMessage(), (Object)e);
            return Response.status((int)503).entity((Object)"JMXConnectionException").build();
        }
        return Response.ok((Object)new JSONArray().put((Object)nodeTool.getReleaseVersion()), (String)"application/json").build();
    }

    @GET
    @Path(value="/disablegossip")
    public Response disablegossip() throws IOException, ExecutionException, InterruptedException {
        JMXNodeTool nodeTool;
        try {
            nodeTool = JMXNodeTool.instance(this.config);
        }
        catch (JMXConnectionException e) {
            logger.error("Exception in fetching c* jmx tool .  Msgl: {}", (Object)e.getLocalizedMessage(), (Object)e);
            return Response.status((int)503).entity((Object)"JMXConnectionException").build();
        }
        nodeTool.stopGossiping();
        return Response.ok((Object)REST_SUCCESS, (String)"application/json").build();
    }

    @GET
    @Path(value="/enablegossip")
    public Response enablegossip() throws IOException, ExecutionException, InterruptedException {
        JMXNodeTool nodeTool;
        try {
            nodeTool = JMXNodeTool.instance(this.config);
        }
        catch (JMXConnectionException e) {
            logger.error("Exception in fetching c* jmx tool .  Msgl: {}", (Object)e.getLocalizedMessage(), (Object)e);
            return Response.status((int)503).entity((Object)"JMXConnectionException").build();
        }
        nodeTool.startGossiping();
        return Response.ok((Object)REST_SUCCESS, (String)"application/json").build();
    }

    @GET
    @Path(value="/gossipinfo")
    public Response gossipinfo() throws IOException, ExecutionException, InterruptedException, JSONException {
        JMXNodeTool nodeTool;
        try {
            nodeTool = JMXNodeTool.instance(this.config);
        }
        catch (JMXConnectionException e) {
            logger.error("Exception in fetching c* jmx tool .  Msgl: {}", (Object)e.getLocalizedMessage(), (Object)e);
            return Response.status((int)503).entity((Object)"JMXConnectionException").build();
        }
        JSONObject rootObj = CassandraAdmin.parseGossipInfo(nodeTool.getGossipInfo(false));
        return Response.ok((Object)rootObj, (String)"application/json").build();
    }

    private static JSONObject parseGossipInfo(String gossipinfo) throws JSONException {
        String[] ginfo = gossipinfo.split("\n");
        JSONObject rootObj = new JSONObject();
        JSONObject obj = new JSONObject();
        String key = "";
        for (String line : ginfo) {
            if (line.matches("^.*/.*$")) {
                String[] data = line.split("/");
                if (StringUtils.isNotBlank((CharSequence)key)) {
                    rootObj.put(key, (Object)obj);
                    obj = new JSONObject();
                }
                key = data[1];
                continue;
            }
            if (!line.matches("^  .*:.*$")) continue;
            String[] kv = line.split(":");
            kv[0] = kv[0].trim();
            if (kv[0].equals("STATUS")) {
                obj.put(kv[0], (Object)kv[1]);
                String[] vv = kv[1].split(",");
                obj.put("Token", (Object)vv[1]);
                continue;
            }
            obj.put(kv[0], (Object)kv[1]);
        }
        if (StringUtils.isNotBlank((CharSequence)key)) {
            rootObj.put(key, (Object)obj);
        }
        return rootObj;
    }

    @GET
    @Path(value="/move")
    public Response moveToken(@QueryParam(value="token") String newToken) throws IOException, ExecutionException, InterruptedException, ConfigurationException {
        JMXNodeTool nodeTool;
        try {
            nodeTool = JMXNodeTool.instance(this.config);
        }
        catch (JMXConnectionException e) {
            logger.error("Exception in fetching c* jmx tool .  Msgl: {}", (Object)e.getLocalizedMessage(), (Object)e);
            return Response.status((int)503).entity((Object)"JMXConnectionException").build();
        }
        nodeTool.move(newToken);
        return Response.ok((Object)REST_SUCCESS, (String)"application/json").build();
    }

    @GET
    @Path(value="/drain")
    public Response cassDrain() throws IOException, ExecutionException, InterruptedException {
        JMXNodeTool nodeTool;
        try {
            nodeTool = JMXNodeTool.instance(this.config);
        }
        catch (JMXConnectionException e) {
            logger.error("Exception in fetching c* jmx tool .  Msgl: {}", (Object)e.getLocalizedMessage(), (Object)e);
            return Response.status((int)503).entity((Object)"JMXConnectionException").build();
        }
        logger.debug("node tool drain being called");
        nodeTool.drain();
        return Response.ok((Object)REST_SUCCESS, (String)"application/json").build();
    }

    @GET
    @Path(value="/decompress")
    public Response decompress(@QueryParam(value="in") String in, @QueryParam(value="out") String out) throws Exception {
        SnappyCompression compress = new SnappyCompression();
        compress.decompressAndClose(new FileInputStream(in), new FileOutputStream(out));
        JSONObject object = new JSONObject();
        object.put("Input compressed file", (Object)in);
        object.put("Output decompress file", (Object)out);
        return Response.ok((Object)object.toString(), (String)"application/json").build();
    }
}

