/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.resources;

import com.google.inject.Inject;
import com.netflix.priam.PriamServer;
import com.netflix.priam.identity.DoubleRing;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/cassconfig")
@Produces(value={"text/plain"})
public class CassandraConfig {
    private static final Logger logger = LoggerFactory.getLogger(CassandraConfig.class);
    private PriamServer priamServer;
    private DoubleRing doubleRing;

    @Inject
    public CassandraConfig(PriamServer server, DoubleRing doubleRing) {
        this.priamServer = server;
        this.doubleRing = doubleRing;
    }

    @GET
    @Path(value="/get_seeds")
    public Response getSeeds() {
        try {
            List<String> seeds = this.priamServer.getId().getSeeds();
            if (!seeds.isEmpty()) {
                return Response.ok((Object)StringUtils.join(seeds, (char)',')).build();
            }
            logger.error("Cannot find the Seeds");
        }
        catch (Exception e) {
            logger.error("Error while executing get_seeds", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.status((int)500).build();
    }

    @GET
    @Path(value="/get_token")
    public Response getToken() {
        try {
            String token = this.priamServer.getId().getInstance().getToken();
            if (StringUtils.isNotBlank((CharSequence)token)) {
                logger.info("Returning token value \"{}\" for this instance to caller.", (Object)token);
                return Response.ok((Object)this.priamServer.getId().getInstance().getToken()).build();
            }
            logger.error("Cannot find token for this instance.");
        }
        catch (Exception e) {
            logger.error("Error while executing get_token", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.status((int)500).build();
    }

    @GET
    @Path(value="/is_replace_token")
    public Response isReplaceToken() {
        try {
            return Response.ok((Object)String.valueOf(this.priamServer.getId().isReplace())).build();
        }
        catch (Exception e) {
            logger.error("Error while executing is_replace_token", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="/get_replaced_ip")
    public Response getReplacedIp() {
        try {
            return Response.ok((Object)String.valueOf(this.priamServer.getId().getReplacedIp())).build();
        }
        catch (Exception e) {
            logger.error("Error while executing get_replaced_ip", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="/set_replaced_ip")
    public Response setReplacedIp(@QueryParam(value="ip") String ip) {
        try {
            this.priamServer.getId().setReplacedIp(ip);
            return Response.ok().build();
        }
        catch (Exception e) {
            logger.error("Error while overriding replacement ip", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="/get_extra_env_params")
    public Response getExtraEnvParams() {
        try {
            Map<String, String> returnMap = this.priamServer.getConfiguration().getExtraEnvParams();
            if (returnMap == null) {
                returnMap = new HashMap<String, String>();
            }
            String extraEnvParamsJson = JSONValue.toJSONString(returnMap);
            return Response.ok((Object)extraEnvParamsJson).build();
        }
        catch (Exception e) {
            logger.error("Error while executing get_extra_env_params", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="/double_ring")
    public Response doubleRing() throws IOException, ClassNotFoundException {
        try {
            this.doubleRing.backup();
            this.doubleRing.doubleSlots();
        }
        catch (Throwable th) {
            logger.error("Error in doubling the ring...", th);
            this.doubleRing.restore();
            throw new RuntimeException(th);
        }
        return Response.status((int)200).build();
    }
}

