/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.restore;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.netflix.priam.backup.AbstractBackupPath;
import com.netflix.priam.backup.IBackupFileSystem;
import com.netflix.priam.backup.MetaData;
import com.netflix.priam.config.IConfiguration;
import com.netflix.priam.defaultimpl.ICassandraProcess;
import com.netflix.priam.health.InstanceState;
import com.netflix.priam.identity.InstanceIdentity;
import com.netflix.priam.restore.AbstractRestore;
import com.netflix.priam.restore.IPostRestoreHook;
import com.netflix.priam.restore.RestoreTokenSelector;
import com.netflix.priam.scheduler.NamedThreadPoolExecutor;
import com.netflix.priam.scheduler.SimpleTimer;
import com.netflix.priam.scheduler.TaskTimer;
import com.netflix.priam.utils.RetryableCallable;
import com.netflix.priam.utils.Sleeper;
import java.io.File;
import java.io.FileOutputStream;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Restore
extends AbstractRestore {
    public static final String JOBNAME = "AUTO_RESTORE_JOB";
    private static final Logger logger = LoggerFactory.getLogger(Restore.class);
    private final ThreadPoolExecutor executor;
    private AtomicInteger count = new AtomicInteger();

    @Inject
    public Restore(IConfiguration config, @Named(value="backup") IBackupFileSystem fs, Sleeper sleeper, ICassandraProcess cassProcess, Provider<AbstractBackupPath> pathProvider, InstanceIdentity instanceIdentity, RestoreTokenSelector tokenSelector, MetaData metaData, InstanceState instanceState, IPostRestoreHook postRestoreHook) {
        super(config, fs, JOBNAME, sleeper, pathProvider, instanceIdentity, tokenSelector, cassProcess, metaData, instanceState, postRestoreHook);
        this.executor = new NamedThreadPoolExecutor(config.getMaxBackupDownloadThreads(), JOBNAME);
        this.executor.allowCoreThreadTimeOut(true);
    }

    @Override
    protected final void downloadFile(final AbstractBackupPath path, final File restoreLocation) throws Exception {
        this.count.incrementAndGet();
        this.executor.submit(new RetryableCallable<Integer>(){

            @Override
            public Integer retriableCall() throws Exception {
                logger.info("Downloading file: {} to: {}", (Object)path.getRemotePath(), (Object)restoreLocation.getAbsolutePath());
                Restore.this.fs.download(path, new FileOutputStream(restoreLocation), restoreLocation.getAbsolutePath());
                AbstractRestore.tracker.adjustAndAdd(path);
                logger.info("Completed download of file: {} to: {}", (Object)path.getRemotePath(), (Object)restoreLocation.getAbsolutePath());
                return Restore.this.count.decrementAndGet();
            }
        });
    }

    @Override
    protected final void waitToComplete() {
        while (this.count.get() != 0) {
            try {
                this.sleeper.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.error("Interrupted: ", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    public static TaskTimer getTimer() {
        return new SimpleTimer(JOBNAME);
    }

    @Override
    public String getName() {
        return JOBNAME;
    }

    public int getActiveCount() {
        return this.executor == null ? 0 : this.executor.getActiveCount();
    }
}

