/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.tuner;

import com.netflix.priam.tuner.GCType;
import com.netflix.priam.tuner.JVMOption;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Singleton;

@Singleton
public class GCTuner {
    private static final Set<String> cmsOptions = new HashSet<String>(Arrays.asList("-XX:+UseConcMarkSweepGC", "-XX:+UseParNewGC", "-XX:+UseParallelGC", "-XX:+CMSConcurrentMTEnabled", "-XX:CMSInitiatingOccupancyFraction", "-XX:+UseCMSInitiatingOccupancyOnly", "-XX:+CMSClassUnloadingEnabled", "-XX:+CMSIncrementalMode", "-XX:+CMSPermGenSweepingEnabled", "-XX:+ExplicitGCInvokesConcurrent", "-XX:+ExplicitGCInvokesConcurrentAndUnloadsClasses", "-XX:+DisableExplicitGC", "-XX:+CMSParallelRemarkEnabled", "-XX:SurvivorRatio", "-XX:MaxTenuringThreshold", "-XX:CMSWaitDuration", "-XX:+CMSParallelInitialMarkEnabled", "-XX:+CMSEdenChunksRecordAlways"));
    private static final Set<String> g1gcOptions = new HashSet<String>(Arrays.asList("-XX:+UseG1GC", "-XX:G1HeapRegionSize", "-XX:MaxGCPauseMillis", "-XX:G1NewSizePercent", "-XX:G1MaxNewSizePercent", "-XX:-ResizePLAB", "-XX:InitiatingHeapOccupancyPercent", "-XX:G1MixedGCLiveThresholdPercent", "-XX:G1HeapWastePercent", "-XX:G1MixedGCCountTarget", "-XX:G1OldCSetRegionThresholdPercent", "-XX:G1ReservePercent", "-XX:SoftRefLRUPolicyMSPerMB", "-XX:G1ConcRefinementThreads", "-XX:MaxGCPauseMillis", "-XX:+UnlockExperimentalVMOptions", "-XX:NewRatio", "-XX:G1RSetUpdatingPauseTimePercent"));

    static final GCType getGCType(String option) {
        if (cmsOptions.contains(option)) {
            return GCType.CMS;
        }
        if (g1gcOptions.contains(option)) {
            return GCType.G1GC;
        }
        return null;
    }

    static final GCType getGCType(JVMOption jvmOption) {
        return GCTuner.getGCType(jvmOption.getJvmOption());
    }

    public Set<String> getCmsOptions() {
        return cmsOptions;
    }

    public Set<String> getG1gcOptions() {
        return g1gcOptions;
    }
}

