/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.priam.tuner;

import com.netflix.priam.scheduler.UnsupportedTypeException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum GCType {
    CMS("CMS"),
    G1GC("G1GC");

    private static final Logger logger;
    private final String gcType;

    private GCType(String gcType) {
        this.gcType = gcType.toUpperCase();
    }

    public static GCType lookup(String gcType, boolean acceptNullOrEmpty, boolean acceptIllegalValue) throws UnsupportedTypeException {
        if (StringUtils.isEmpty((CharSequence)gcType)) {
            if (acceptNullOrEmpty) {
                return null;
            }
            String message = String.format("%s is not a supported GC Type. Supported values are %s", gcType, GCType.getSupportedValues());
            logger.error(message);
            throw new UnsupportedTypeException(message);
        }
        try {
            return GCType.valueOf(gcType.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            String message = String.format("%s is not a supported GCType. Supported values are %s", gcType, GCType.getSupportedValues());
            if (acceptIllegalValue) {
                message = message + ". Since acceptIllegalValue is set to True, returning NULL instead.";
                logger.error(message);
                return null;
            }
            logger.error(message);
            throw new UnsupportedTypeException(message, ex);
        }
    }

    private static String getSupportedValues() {
        StringBuffer supportedValues = new StringBuffer();
        boolean first = true;
        for (GCType type : GCType.values()) {
            if (!first) {
                supportedValues.append(",");
            }
            supportedValues.append((Object)type);
            first = false;
        }
        return supportedValues.toString();
    }

    public static GCType lookup(String gcType) throws UnsupportedTypeException {
        return GCType.lookup(gcType, false, false);
    }

    public String getGcType() {
        return this.gcType;
    }

    static {
        logger = LoggerFactory.getLogger(GCType.class);
    }
}

