/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.client;

import com.netflix.client.VipAddressResolver;
import com.netflix.client.config.IClientConfig;
import com.netflix.config.ConfigurationManager;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SimpleVipAddressResolver
implements VipAddressResolver {
    private static final Pattern VAR_PATTERN = Pattern.compile("\\$\\{(.*?)\\}");

    public String resolve(String vipAddressMacro, IClientConfig niwsClientConfig) {
        if (vipAddressMacro == null || vipAddressMacro.length() == 0) {
            return vipAddressMacro;
        }
        return SimpleVipAddressResolver.replaceMacrosFromConfig(vipAddressMacro);
    }

    private static String replaceMacrosFromConfig(String macro) {
        String result = macro;
        Matcher matcher = VAR_PATTERN.matcher(result);
        while (matcher.find()) {
            String key = matcher.group(1);
            String value = ConfigurationManager.getConfigInstance().getString(key);
            if (value == null) continue;
            result = result.replaceAll("\\$\\{" + key + "\\}", value);
            matcher = VAR_PATTERN.matcher(result);
        }
        return result.trim();
    }
}

