/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.client.config;

import com.netflix.client.config.ClientConfigFactory;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfigKey;
import com.netflix.client.config.Property;
import java.util.Map;

public interface IClientConfig {
    public String getClientName();

    public String getNameSpace();

    public void setNameSpace(String var1);

    public void loadProperties(String var1);

    public void loadDefaultValues();

    public Map<String, Object> getProperties();

    @Deprecated
    public void setProperty(IClientConfigKey var1, Object var2);

    @Deprecated
    public Object getProperty(IClientConfigKey var1);

    @Deprecated
    public Object getProperty(IClientConfigKey var1, Object var2);

    public boolean containsProperty(IClientConfigKey var1);

    public String resolveDeploymentContextbasedVipAddresses();

    public int getPropertyAsInteger(IClientConfigKey var1, int var2);

    public String getPropertyAsString(IClientConfigKey var1, String var2);

    public boolean getPropertyAsBoolean(IClientConfigKey var1, boolean var2);

    public <T> T get(IClientConfigKey<T> var1);

    default public <T> T getOrDefault(IClientConfigKey<T> key) {
        return this.get(key, key.defaultValue());
    }

    public <T> Property<T> getGlobalProperty(IClientConfigKey<T> var1);

    public <T> Property<T> getDynamicProperty(IClientConfigKey<T> var1);

    public <T> T get(IClientConfigKey<T> var1, T var2);

    public <T> IClientConfig set(IClientConfigKey<T> var1, T var2);

    public static class Builder {
        private IClientConfig config;

        Builder() {
        }

        public static Builder newBuilder() {
            Builder builder = new Builder();
            builder.config = ClientConfigFactory.findDefaultConfigFactory().newConfig();
            return builder;
        }

        public static Builder newBuilder(String clientName) {
            Builder builder = new Builder();
            builder.config = ClientConfigFactory.findDefaultConfigFactory().newConfig();
            builder.config.loadProperties(clientName);
            return builder;
        }

        public static Builder newBuilder(String clientName, String propertyNameSpace) {
            Builder builder = new Builder();
            builder.config = ClientConfigFactory.findDefaultConfigFactory().newConfig();
            builder.config.setNameSpace(propertyNameSpace);
            builder.config.loadProperties(clientName);
            return builder;
        }

        public static Builder newBuilder(Class<? extends IClientConfig> implClass, String clientName) {
            Builder builder = new Builder();
            try {
                builder.config = implClass.newInstance();
                builder.config.loadProperties(clientName);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
            return builder;
        }

        public static Builder newBuilder(Class<? extends IClientConfig> implClass) {
            Builder builder = new Builder();
            try {
                builder.config = implClass.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
            return builder;
        }

        public IClientConfig build() {
            return this.config;
        }

        public Builder withDefaultValues() {
            this.config.loadDefaultValues();
            return this;
        }

        public Builder withDeploymentContextBasedVipAddresses(String vipAddress) {
            this.config.set(CommonClientConfigKey.DeploymentContextBasedVipAddresses, vipAddress);
            return this;
        }

        public Builder withForceClientPortConfiguration(boolean forceClientPortConfiguration) {
            this.config.set(CommonClientConfigKey.ForceClientPortConfiguration, forceClientPortConfiguration);
            return this;
        }

        public Builder withMaxAutoRetries(int value) {
            this.config.set(CommonClientConfigKey.MaxAutoRetries, value);
            return this;
        }

        public Builder withMaxAutoRetriesNextServer(int value) {
            this.config.set(CommonClientConfigKey.MaxAutoRetriesNextServer, value);
            return this;
        }

        public Builder withRetryOnAllOperations(boolean value) {
            this.config.set(CommonClientConfigKey.OkToRetryOnAllOperations, value);
            return this;
        }

        public Builder withRequestSpecificRetryOn(boolean value) {
            this.config.set(CommonClientConfigKey.RequestSpecificRetryOn, value);
            return this;
        }

        public Builder withEnablePrimeConnections(boolean value) {
            this.config.set(CommonClientConfigKey.EnablePrimeConnections, value);
            return this;
        }

        public Builder withMaxConnectionsPerHost(int value) {
            this.config.set(CommonClientConfigKey.MaxHttpConnectionsPerHost, value);
            this.config.set(CommonClientConfigKey.MaxConnectionsPerHost, value);
            return this;
        }

        public Builder withMaxTotalConnections(int value) {
            this.config.set(CommonClientConfigKey.MaxTotalHttpConnections, value);
            this.config.set(CommonClientConfigKey.MaxTotalConnections, value);
            return this;
        }

        public Builder withSecure(boolean secure) {
            this.config.set(CommonClientConfigKey.IsSecure, secure);
            return this;
        }

        public Builder withConnectTimeout(int value) {
            this.config.set(CommonClientConfigKey.ConnectTimeout, value);
            return this;
        }

        public Builder withReadTimeout(int value) {
            this.config.set(CommonClientConfigKey.ReadTimeout, value);
            return this;
        }

        public Builder withConnectionManagerTimeout(int value) {
            this.config.set(CommonClientConfigKey.ConnectionManagerTimeout, value);
            return this;
        }

        public Builder withFollowRedirects(boolean value) {
            this.config.set(CommonClientConfigKey.FollowRedirects, value);
            return this;
        }

        public Builder withConnectionPoolCleanerTaskEnabled(boolean value) {
            this.config.set(CommonClientConfigKey.ConnectionPoolCleanerTaskEnabled, value);
            return this;
        }

        public Builder withConnIdleEvictTimeMilliSeconds(int value) {
            this.config.set(CommonClientConfigKey.ConnIdleEvictTimeMilliSeconds, value);
            return this;
        }

        public Builder withConnectionCleanerRepeatIntervalMills(int value) {
            this.config.set(CommonClientConfigKey.ConnectionCleanerRepeatInterval, value);
            return this;
        }

        public Builder withGZIPContentEncodingFilterEnabled(boolean value) {
            this.config.set(CommonClientConfigKey.EnableGZIPContentEncodingFilter, value);
            return this;
        }

        public Builder withProxyHost(String proxyHost) {
            this.config.set(CommonClientConfigKey.ProxyHost, proxyHost);
            return this;
        }

        public Builder withProxyPort(int value) {
            this.config.set(CommonClientConfigKey.ProxyPort, value);
            return this;
        }

        public Builder withKeyStore(String value) {
            this.config.set(CommonClientConfigKey.KeyStore, value);
            return this;
        }

        public Builder withKeyStorePassword(String value) {
            this.config.set(CommonClientConfigKey.KeyStorePassword, value);
            return this;
        }

        public Builder withTrustStore(String value) {
            this.config.set(CommonClientConfigKey.TrustStore, value);
            return this;
        }

        public Builder withTrustStorePassword(String value) {
            this.config.set(CommonClientConfigKey.TrustStorePassword, value);
            return this;
        }

        public Builder withClientAuthRequired(boolean value) {
            this.config.set(CommonClientConfigKey.IsClientAuthRequired, value);
            return this;
        }

        public Builder withCustomSSLSocketFactoryClassName(String value) {
            this.config.set(CommonClientConfigKey.CustomSSLSocketFactoryClassName, value);
            return this;
        }

        public Builder withHostnameValidationRequired(boolean value) {
            this.config.set(CommonClientConfigKey.IsHostnameValidationRequired, value);
            return this;
        }

        public Builder ignoreUserTokenInConnectionPoolForSecureClient(boolean value) {
            this.config.set(CommonClientConfigKey.IgnoreUserTokenInConnectionPoolForSecureClient, value);
            return this;
        }

        public Builder withLoadBalancerEnabled(boolean value) {
            this.config.set(CommonClientConfigKey.InitializeNFLoadBalancer, value);
            return this;
        }

        public Builder withServerListRefreshIntervalMills(int value) {
            this.config.set(CommonClientConfigKey.ServerListRefreshInterval, value);
            return this;
        }

        public Builder withZoneAffinityEnabled(boolean value) {
            this.config.set(CommonClientConfigKey.EnableZoneAffinity, value);
            return this;
        }

        public Builder withZoneExclusivityEnabled(boolean value) {
            this.config.set(CommonClientConfigKey.EnableZoneExclusivity, value);
            return this;
        }

        public Builder prioritizeVipAddressBasedServers(boolean value) {
            this.config.set(CommonClientConfigKey.PrioritizeVipAddressBasedServers, value);
            return this;
        }

        public Builder withTargetRegion(String value) {
            this.config.set(CommonClientConfigKey.TargetRegion, value);
            return this;
        }
    }
}

