/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.client.config;

import com.netflix.client.config.IClientConfig;
import java.util.Comparator;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;

public interface ClientConfigFactory {
    public static final ClientConfigFactory DEFAULT = ClientConfigFactory.findDefaultConfigFactory();

    public IClientConfig newConfig();

    default public int getPriority() {
        return 0;
    }

    public static ClientConfigFactory findDefaultConfigFactory() {
        return StreamSupport.stream(ServiceLoader.load(ClientConfigFactory.class).spliterator(), false).sorted(Comparator.comparingInt(ClientConfigFactory::getPriority).thenComparing(f -> f.getClass().getCanonicalName()).reversed()).findFirst().orElseGet(() -> {
            throw new IllegalStateException("Expecting at least one implementation of ClientConfigFactory discoverable via the ServiceLoader");
        });
    }
}

