/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.niws.loadbalancer;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.client.config.ClientConfigFactory;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.client.config.IClientConfigKey;
import com.netflix.config.ConfigurationManager;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.loadbalancer.AbstractServerList;
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer;
import com.netflix.niws.loadbalancer.LegacyEurekaClientProvider;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryEnabledNIWSServerList
extends AbstractServerList<DiscoveryEnabledServer> {
    private static final Logger logger = LoggerFactory.getLogger(DiscoveryEnabledNIWSServerList.class);
    String clientName;
    String vipAddresses;
    boolean isSecure = false;
    boolean prioritizeVipAddressBasedServers = true;
    String datacenter;
    String targetRegion;
    int overridePort = (Integer)CommonClientConfigKey.Port.getDefaultValue();
    boolean shouldUseOverridePort = false;
    boolean shouldUseIpAddr = false;
    private final Provider<EurekaClient> eurekaClientProvider;

    @Deprecated
    public DiscoveryEnabledNIWSServerList() {
        this.eurekaClientProvider = new LegacyEurekaClientProvider();
    }

    @Deprecated
    public DiscoveryEnabledNIWSServerList(String vipAddresses) {
        this(vipAddresses, (Provider<EurekaClient>)new LegacyEurekaClientProvider());
    }

    @Deprecated
    public DiscoveryEnabledNIWSServerList(IClientConfig clientConfig) {
        this(clientConfig, (Provider<EurekaClient>)new LegacyEurekaClientProvider());
    }

    public DiscoveryEnabledNIWSServerList(String vipAddresses, Provider<EurekaClient> eurekaClientProvider) {
        this(DiscoveryEnabledNIWSServerList.createClientConfig(vipAddresses), eurekaClientProvider);
    }

    public DiscoveryEnabledNIWSServerList(IClientConfig clientConfig, Provider<EurekaClient> eurekaClientProvider) {
        this.eurekaClientProvider = eurekaClientProvider;
        this.initWithNiwsConfig(clientConfig);
    }

    public void initWithNiwsConfig(IClientConfig clientConfig) {
        this.clientName = clientConfig.getClientName();
        this.vipAddresses = clientConfig.resolveDeploymentContextbasedVipAddresses();
        if (this.vipAddresses == null && ConfigurationManager.getConfigInstance().getBoolean("DiscoveryEnabledNIWSServerList.failFastOnNullVip", true)) {
            throw new NullPointerException("VIP address for client " + this.clientName + " is null");
        }
        this.isSecure = Boolean.parseBoolean("" + clientConfig.getProperty(CommonClientConfigKey.IsSecure, (Object)"false"));
        this.prioritizeVipAddressBasedServers = Boolean.parseBoolean("" + clientConfig.getProperty(CommonClientConfigKey.PrioritizeVipAddressBasedServers, (Object)this.prioritizeVipAddressBasedServers));
        this.datacenter = ConfigurationManager.getDeploymentContext().getDeploymentDatacenter();
        this.targetRegion = (String)clientConfig.getProperty(CommonClientConfigKey.TargetRegion);
        this.shouldUseIpAddr = (Boolean)clientConfig.getOrDefault(CommonClientConfigKey.UseIPAddrForServer);
        if (clientConfig.getPropertyAsBoolean(CommonClientConfigKey.ForceClientPortConfiguration, false)) {
            if (this.isSecure) {
                if (clientConfig.containsProperty(CommonClientConfigKey.SecurePort)) {
                    this.overridePort = (Integer)clientConfig.getOrDefault(CommonClientConfigKey.SecurePort);
                    this.shouldUseOverridePort = true;
                } else {
                    logger.warn(this.clientName + " set to force client port but no secure port is set, so ignoring");
                }
            } else if (clientConfig.containsProperty(CommonClientConfigKey.Port)) {
                this.overridePort = (Integer)clientConfig.getOrDefault(CommonClientConfigKey.Port);
                this.shouldUseOverridePort = true;
            } else {
                logger.warn(this.clientName + " set to force client port but no port is set, so ignoring");
            }
        }
    }

    public List<DiscoveryEnabledServer> getInitialListOfServers() {
        return this.obtainServersViaDiscovery();
    }

    public List<DiscoveryEnabledServer> getUpdatedListOfServers() {
        return this.obtainServersViaDiscovery();
    }

    private List<DiscoveryEnabledServer> obtainServersViaDiscovery() {
        ArrayList<DiscoveryEnabledServer> serverList = new ArrayList<DiscoveryEnabledServer>();
        if (this.eurekaClientProvider == null || this.eurekaClientProvider.get() == null) {
            logger.warn("EurekaClient has not been initialized yet, returning an empty list");
            return new ArrayList<DiscoveryEnabledServer>();
        }
        EurekaClient eurekaClient = (EurekaClient)this.eurekaClientProvider.get();
        if (this.vipAddresses != null) {
            for (String vipAddress : this.vipAddresses.split(",")) {
                List listOfInstanceInfo = eurekaClient.getInstancesByVipAddress(vipAddress, this.isSecure, this.targetRegion);
                for (InstanceInfo ii : listOfInstanceInfo) {
                    if (!ii.getStatus().equals((Object)InstanceInfo.InstanceStatus.UP)) continue;
                    if (this.shouldUseOverridePort) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Overriding port on client name: " + this.clientName + " to " + this.overridePort);
                        }
                        InstanceInfo copy = new InstanceInfo(ii);
                        ii = this.isSecure ? new InstanceInfo.Builder(copy).setSecurePort(this.overridePort).build() : new InstanceInfo.Builder(copy).setPort(this.overridePort).build();
                    }
                    DiscoveryEnabledServer des = this.createServer(ii, this.isSecure, this.shouldUseIpAddr);
                    serverList.add(des);
                }
                if (serverList.size() > 0 && this.prioritizeVipAddressBasedServers) break;
            }
        }
        return serverList;
    }

    protected DiscoveryEnabledServer createServer(InstanceInfo instanceInfo, boolean useSecurePort, boolean useIpAddr) {
        DiscoveryEnabledServer server = new DiscoveryEnabledServer(instanceInfo, useSecurePort, useIpAddr);
        EurekaClientConfig clientConfig = ((EurekaClient)this.eurekaClientProvider.get()).getEurekaClientConfig();
        String[] availZones = clientConfig.getAvailabilityZones(clientConfig.getRegion());
        String instanceZone = InstanceInfo.getZone((String[])availZones, (InstanceInfo)instanceInfo);
        server.setZone(instanceZone);
        return server;
    }

    public String getVipAddresses() {
        return this.vipAddresses;
    }

    public void setVipAddresses(String vipAddresses) {
        this.vipAddresses = vipAddresses;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DiscoveryEnabledNIWSServerList:");
        sb.append("; clientName:").append(this.clientName);
        sb.append("; Effective vipAddresses:").append(this.vipAddresses);
        sb.append("; isSecure:").append(this.isSecure);
        sb.append("; datacenter:").append(this.datacenter);
        return sb.toString();
    }

    private static IClientConfig createClientConfig(String vipAddresses) {
        IClientConfig clientConfig = ClientConfigFactory.DEFAULT.newConfig();
        clientConfig.set(IClientConfigKey.Keys.DeploymentContextBasedVipAddresses, (Object)vipAddresses);
        return clientConfig;
    }
}

