/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.http4;

import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.apache.http.conn.ClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionPoolCleaner {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionPoolCleaner.class);
    String name = "default";
    ClientConnectionManager connMgr;
    Timer timer;
    private DynamicIntProperty connIdleEvictTimeMilliSeconds = DynamicPropertyFactory.getInstance().getIntProperty("default.nfhttpclient.connIdleEvictTimeMilliSeconds", 30000);
    boolean enableConnectionPoolCleanerTask = false;
    long connectionCleanerTimerDelay = 10L;
    long connectionCleanerRepeatInterval = 30000L;

    public ConnectionPoolCleaner(String name, ClientConnectionManager connMgr) {
        this.name = name;
        this.connMgr = connMgr;
    }

    public DynamicIntProperty getConnIdleEvictTimeMilliSeconds() {
        return this.connIdleEvictTimeMilliSeconds;
    }

    public void setConnIdleEvictTimeMilliSeconds(DynamicIntProperty connIdleEvictTimeMilliSeconds) {
        this.connIdleEvictTimeMilliSeconds = connIdleEvictTimeMilliSeconds;
    }

    public boolean isEnableConnectionPoolCleanerTask() {
        return this.enableConnectionPoolCleanerTask;
    }

    public void setEnableConnectionPoolCleanerTask(boolean enableConnectionPoolCleanerTask) {
        this.enableConnectionPoolCleanerTask = enableConnectionPoolCleanerTask;
    }

    public long getConnectionCleanerTimerDelay() {
        return this.connectionCleanerTimerDelay;
    }

    public void setConnectionCleanerTimerDelay(long connectionCleanerTimerDelay) {
        this.connectionCleanerTimerDelay = connectionCleanerTimerDelay;
    }

    public long getConnectionCleanerRepeatInterval() {
        return this.connectionCleanerRepeatInterval;
    }

    public void setConnectionCleanerRepeatInterval(long connectionCleanerRepeatInterval) {
        this.connectionCleanerRepeatInterval = connectionCleanerRepeatInterval;
    }

    public void initTask() {
        if (this.enableConnectionPoolCleanerTask) {
            this.timer = new Timer(this.name + "-ConnectionPoolCleanerThread", true);
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        ConnectionPoolCleaner.this.cleanupConnections();
                    }
                    catch (Throwable e) {
                        logger.error("Exception in ConnectionPoolCleanerThread", e);
                    }
                }
            }, this.connectionCleanerTimerDelay, this.connectionCleanerRepeatInterval);
            logger.info("Initializing ConnectionPoolCleaner for NFHttpClient:" + this.name);
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    logger.info("Stopping the ConnectionPoolCleaner Update Task");
                    ConnectionPoolCleaner.this.timer.cancel();
                }
            }));
        }
    }

    void cleanupConnections() {
        this.connMgr.closeExpiredConnections();
        this.connMgr.closeIdleConnections((long)this.connIdleEvictTimeMilliSeconds.get(), TimeUnit.MILLISECONDS);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ConnectionPoolCleaner:" + this.name);
        sb.append(", connIdleEvictTimeMilliSeconds:" + this.connIdleEvictTimeMilliSeconds.get());
        sb.append(", connectionCleanerTimerDelay:" + this.connectionCleanerTimerDelay);
        sb.append(", connectionCleanerRepeatInterval:" + this.connectionCleanerRepeatInterval);
        return sb.toString();
    }
}

