/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.client;

import com.netflix.client.IPrimeConnection;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.Server;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.monitor.Stopwatch;
import com.netflix.servo.monitor.Timer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimeConnections {
    private static final Logger logger = LoggerFactory.getLogger(PrimeConnections.class);
    String primeConnectionsURIPath = "/";
    private ExecutorService executorService;
    private int maxExecutorThreads = 5;
    private long executorThreadTimeout = 30000L;
    private String name = "default";
    private int maxTasksPerExecutorQueue = 100;
    private float primeRatio = 1.0f;
    int maxRetries = 9;
    long maxTotalTimeToPrimeConnections = 30000L;
    long totalTimeTaken = 0L;
    private boolean aSync = true;
    Counter totalCounter;
    Counter successCounter;
    Timer initialPrimeTimer;
    private IPrimeConnection connector;

    private PrimeConnections() {
    }

    public PrimeConnections(String name, IClientConfig niwsClientConfig) {
        int maxRetriesPerServerPrimeConnection = 9;
        long maxTotalTimeToPrimeConnections = 30000L;
        String primeConnectionsURI = "/";
        String className = "com.netflix.niws.client.http.HttpPrimeConnection";
        try {
            maxRetriesPerServerPrimeConnection = Integer.parseInt(String.valueOf(niwsClientConfig.getProperty(CommonClientConfigKey.MaxRetriesPerServerPrimeConnection, (Object)maxRetriesPerServerPrimeConnection)));
        }
        catch (Exception e) {
            logger.warn("Invalid maxRetriesPerServerPrimeConnection");
        }
        try {
            maxTotalTimeToPrimeConnections = Long.parseLong(String.valueOf(niwsClientConfig.getProperty(CommonClientConfigKey.MaxTotalTimeToPrimeConnections, (Object)maxTotalTimeToPrimeConnections)));
        }
        catch (Exception e) {
            logger.warn("Invalid maxTotalTimeToPrimeConnections");
        }
        primeConnectionsURI = String.valueOf(niwsClientConfig.getProperty(CommonClientConfigKey.PrimeConnectionsURI, (Object)primeConnectionsURI));
        float primeRatio = Float.parseFloat(String.valueOf(niwsClientConfig.getProperty(CommonClientConfigKey.MinPrimeConnectionsRatio)));
        className = (String)niwsClientConfig.getProperty(CommonClientConfigKey.PrimeConnectionsClassName, (Object)"com.netflix.niws.client.http.HttpPrimeConnection");
        try {
            this.connector = (IPrimeConnection)Class.forName(className).newInstance();
            this.connector.initWithNiwsConfig(niwsClientConfig);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to initialize prime connections", e);
        }
        this.setUp(name, maxRetriesPerServerPrimeConnection, maxTotalTimeToPrimeConnections, primeConnectionsURI, primeRatio);
    }

    public PrimeConnections(String name, int maxRetries, long maxTotalTimeToPrimeConnections, String primeConnectionsURI) {
        this.setUp(name, maxRetries, maxTotalTimeToPrimeConnections, primeConnectionsURI, 1.0f);
    }

    public PrimeConnections(String name, int maxRetries, long maxTotalTimeToPrimeConnections, String primeConnectionsURI, float primeRatio) {
        this.setUp(name, maxRetries, maxTotalTimeToPrimeConnections, primeConnectionsURI, primeRatio);
    }

    private void setUp(String name, int maxRetries, long maxTotalTimeToPrimeConnections, String primeConnectionsURI, float primeRatio) {
        this.name = name;
        this.maxRetries = maxRetries;
        this.maxTotalTimeToPrimeConnections = maxTotalTimeToPrimeConnections;
        this.primeConnectionsURIPath = primeConnectionsURI;
        this.primeRatio = primeRatio;
        this.executorService = new ThreadPoolExecutor(1, this.maxExecutorThreads, this.executorThreadTimeout, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(this.maxTasksPerExecutorQueue), new ASyncPrimeConnectionsThreadFactory(name));
        this.totalCounter = Monitors.newCounter((String)(name + "_PrimeConnection_TotalCounter"));
        this.successCounter = Monitors.newCounter((String)(name + "_PrimeConnection_SuccessCounter"));
        this.initialPrimeTimer = Monitors.newTimer((String)(name + "_initialPrimeConnectionsTimer"), (TimeUnit)TimeUnit.MILLISECONDS);
        Monitors.registerObject((String)(name + "_PrimeConnection"), (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void primeConnections(List<Server> servers) {
        if (servers == null || servers.size() == 0) {
            logger.debug("No server to prime");
            return;
        }
        for (Server server : servers) {
            server.setReadyToServe(false);
        }
        int totalCount = (int)((float)servers.size() * this.primeRatio);
        final CountDownLatch latch = new CountDownLatch(totalCount);
        final AtomicInteger successCount = new AtomicInteger(0);
        final AtomicInteger failureCount = new AtomicInteger(0);
        this.primeConnectionsAsync(servers, new PrimeConnectionListener(){

            @Override
            public void primeCompleted(Server s, Throwable lastException) {
                if (lastException == null) {
                    successCount.incrementAndGet();
                    s.setReadyToServe(true);
                } else {
                    failureCount.incrementAndGet();
                }
                latch.countDown();
            }
        });
        Stopwatch stopWatch = this.initialPrimeTimer.start();
        try {
            latch.await(this.maxTotalTimeToPrimeConnections, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            logger.error("Priming connection interrupted", (Throwable)e);
        }
        finally {
            stopWatch.stop();
        }
        this.printStats(totalCount, successCount.get(), failureCount.get(), stopWatch.getDuration(TimeUnit.MILLISECONDS));
    }

    private void printStats(int total, int success, int failure, long totalTime) {
        if (total != success) {
            logger.info("Priming Connections not fully successful");
        } else {
            logger.info("Priming connections fully successful");
        }
        logger.debug("numServers left to be 'primed'=" + (total - success));
        logger.debug("numServers successfully 'primed'=" + success);
        logger.debug("numServers whose attempts not complete exclusively due to max time allocated=" + (total - (success + failure)));
        logger.debug("Total Time Taken=" + totalTime + " msecs, out of an allocated max of (msecs)=" + this.maxTotalTimeToPrimeConnections);
    }

    public List<Future<Boolean>> primeConnectionsAsync(List<Server> servers, PrimeConnectionListener listener) {
        if (servers == null) {
            return Collections.emptyList();
        }
        ArrayList<Server> allServers = new ArrayList<Server>();
        allServers.addAll(servers);
        if (allServers.size() == 0) {
            logger.debug("RestClient:" + this.name + ". No nodes/servers to prime connections");
            return Collections.emptyList();
        }
        logger.info("Priming Connections for RestClient:" + this.name + ", numServers:" + allServers.size());
        ArrayList<Future<Boolean>> ftList = new ArrayList<Future<Boolean>>();
        for (Server s : allServers) {
            s.setReadyToServe(false);
            if (this.aSync) {
                Future<Boolean> ftC = null;
                try {
                    ftC = this.makeConnectionASync(s, listener);
                    ftList.add(ftC);
                }
                catch (Throwable e) {}
                continue;
            }
            this.connectToServer(s, listener);
        }
        return ftList;
    }

    private Future<Boolean> makeConnectionASync(final Server s, final PrimeConnectionListener listener) throws InterruptedException, ExecutionException {
        Callable<Boolean> ftConn = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                logger.debug("calling primeconnections ...");
                return PrimeConnections.this.connectToServer(s, listener);
            }
        };
        return this.executorService.submit(ftConn);
    }

    public void shutdown() {
        this.executorService.shutdown();
        Monitors.unregisterObject((String)(this.name + "_PrimeConnection"), (Object)this);
    }

    private Boolean connectToServer(Server s, PrimeConnectionListener listener) {
        int tryNum = 0;
        Exception lastException = null;
        this.totalCounter.increment();
        boolean success = false;
        while (true) {
            try {
                logger.debug("Executing PrimeConnections request to server " + s + " with path " + this.primeConnectionsURIPath + ", tryNum=" + tryNum);
                success = this.connector.connect(s, this.primeConnectionsURIPath);
                this.successCounter.increment();
            }
            catch (Exception e) {
                logger.debug("Error connecting to server: {}", (Object)e.getMessage());
                lastException = e;
                this.sleepBeforeRetry(tryNum);
                logger.debug("server:" + s + ", result=" + success + ", tryNum=" + tryNum + ", maxRetries=" + this.maxRetries);
                if (!success && ++tryNum <= this.maxRetries) continue;
            }
            break;
        }
        if (listener != null) {
            try {
                listener.primeCompleted(s, lastException);
            }
            catch (Throwable e) {
                logger.error("Error calling PrimeComplete listener", e);
            }
        }
        logger.debug("Either done, or quitting server:" + s + ", result=" + success + ", tryNum=" + tryNum + ", maxRetries=" + this.maxRetries);
        return success;
    }

    private void sleepBeforeRetry(int tryNum) {
        try {
            int sleep = (tryNum + 1) * 100;
            logger.debug("Sleeping for " + sleep + "ms ...");
            Thread.sleep(sleep);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static class ASyncPrimeConnectionsThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger groupNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        ASyncPrimeConnectionsThreadFactory(String name) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "ASyncPrimeConnectionsThreadFactory-" + name + "-" + groupNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (!t.isDaemon()) {
                t.setDaemon(true);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    static class PrimeConnectionCounters {
        final AtomicInteger numServersLeft;
        final AtomicInteger numServers;
        final AtomicInteger numServersSuccessful;

        public PrimeConnectionCounters(int initialSize) {
            this.numServersLeft = new AtomicInteger(initialSize);
            this.numServers = new AtomicInteger(initialSize);
            this.numServersSuccessful = new AtomicInteger(0);
        }
    }

    public static interface PrimeConnectionListener {
        public void primeCompleted(Server var1, Throwable var2);
    }
}

