/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.loadbalancer.reactive;

import com.netflix.client.RetryHandler;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.LoadBalancerContext;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.reactive.ExecutionContext;
import com.netflix.loadbalancer.reactive.ExecutionContextListenerInvoker;
import com.netflix.loadbalancer.reactive.ExecutionListener;
import com.netflix.loadbalancer.reactive.LoadBalancerCommand;
import com.netflix.loadbalancer.reactive.LoadBalancerExecutable;
import com.netflix.loadbalancer.reactive.LoadBalancerObservable;
import com.netflix.loadbalancer.reactive.LoadBalancerObservableCommand;
import com.netflix.loadbalancer.reactive.LoadBalancerRetrySameServerCommand;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import rx.Observable;

public class CommandBuilder<T> {
    private RetryHandler retryHandler;
    private ILoadBalancer loadBalancer;
    private IClientConfig config;
    private LoadBalancerContext loadBalancerContext;
    private List<? extends ExecutionListener<?, T>> listeners;
    private Object loadBalancerKey;
    private URI serviceLocator;

    private CommandBuilder() {
    }

    public static <T> CommandBuilder<T> newBuilder() {
        return new CommandBuilder<T>();
    }

    public CommandBuilder<T> withLoadBalancer(ILoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
        return this;
    }

    public CommandBuilder<T> withListeners(List<? extends ExecutionListener<?, T>> listeners) {
        if (this.listeners == null) {
            this.listeners = new LinkedList(listeners);
        } else {
            this.listeners.addAll(listeners);
        }
        return this;
    }

    public CommandBuilder<T> withRetryHandler(RetryHandler retryHandler) {
        this.retryHandler = retryHandler;
        return this;
    }

    public CommandBuilder<T> withClientConfig(IClientConfig config) {
        this.config = config;
        return this;
    }

    public CommandBuilder<T> withServiceLocator(URI serviceLocator) {
        this.serviceLocator = serviceLocator;
        return this;
    }

    public CommandBuilder<T> withServerLocator(Object key) {
        this.loadBalancerKey = key;
        return this;
    }

    public CommandBuilder<T> withLoadBalancerContext(LoadBalancerContext loadBalancerContext) {
        this.loadBalancerContext = loadBalancerContext;
        return this;
    }

    public LoadBalancerRetrySameServerCommand<T> build() {
        return this.build((ExecutionContext)null);
    }

    public LoadBalancerRetrySameServerCommand<T> build(ExecutionContext<?> executionContext) {
        if (this.loadBalancerContext == null && this.loadBalancer == null) {
            throw new IllegalArgumentException("Either LoadBalancer or LoadBalancerContext needs to be set");
        }
        ExecutionContextListenerInvoker invoker = null;
        if (this.listeners != null && this.listeners.size() > 0 && executionContext != null) {
            invoker = new ExecutionContextListenerInvoker(executionContext, this.listeners);
        }
        LoadBalancerContext loadBalancerContext1 = this.loadBalancerContext == null ? new LoadBalancerContext(this.loadBalancer, this.config) : this.loadBalancerContext;
        return new LoadBalancerRetrySameServerCommand(loadBalancerContext1, this.retryHandler, invoker);
    }

    public LoadBalancerObservableCommand<T> build(LoadBalancerObservable<T> executable) {
        return this.build(executable, null);
    }

    public LoadBalancerObservableCommand<T> build(final LoadBalancerObservable<T> executable, ExecutionContext<?> executionContext) {
        if (this.loadBalancerContext == null && this.loadBalancer == null) {
            throw new IllegalArgumentException("Either LoadBalancer or LoadBalancerContext needs to be set");
        }
        ExecutionContextListenerInvoker invoker = null;
        if (this.listeners != null && this.listeners.size() > 0) {
            invoker = new ExecutionContextListenerInvoker(executionContext, this.listeners);
        }
        LoadBalancerContext loadBalancerContext1 = this.loadBalancerContext == null ? new LoadBalancerContext(this.loadBalancer, this.config) : this.loadBalancerContext;
        return new LoadBalancerObservableCommand<T>(loadBalancerContext1, this.retryHandler, this.serviceLocator, this.loadBalancerKey, invoker){

            @Override
            public Observable<T> call(Server server) {
                return executable.call(server);
            }
        };
    }

    public LoadBalancerCommand<T> build(final LoadBalancerExecutable<T> executable) {
        if (this.loadBalancerContext == null && this.loadBalancer == null) {
            throw new IllegalArgumentException("Either LoadBalancer or LoadBalancerContext needs to be set");
        }
        LoadBalancerContext loadBalancerContext1 = this.loadBalancerContext == null ? new LoadBalancerContext(this.loadBalancer, this.config) : this.loadBalancerContext;
        return new LoadBalancerCommand<T>(loadBalancerContext1, this.retryHandler, this.serviceLocator, this.loadBalancerKey){

            @Override
            public T run(Server server) throws Exception {
                return executable.run(server);
            }
        };
    }
}

