/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.loadbalancer.reactive;

import com.netflix.loadbalancer.reactive.ExecutionContext;
import com.netflix.loadbalancer.reactive.ExecutionInfo;
import com.netflix.loadbalancer.reactive.ExecutionListener;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionContextListenerInvoker<I, O> {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionContextListenerInvoker.class);
    private final ExecutionContext<I> context;
    private final List<ExecutionListener<I, O>> listeners;

    public ExecutionContextListenerInvoker(ExecutionContext<I> context, List<ExecutionListener<I, O>> listeners) {
        this.listeners = Collections.unmodifiableList(listeners);
        this.context = context;
    }

    public ExecutionContextListenerInvoker(List<ExecutionListener<I, O>> listeners) {
        this(null, listeners);
    }

    public void onExecutionStart() {
        this.onExecutionStart(this.context);
    }

    public void onExecutionStart(ExecutionContext<I> context) {
        for (ExecutionListener<I, O> listener : this.listeners) {
            try {
                listener.onExecutionStart(context.getChildContext(listener));
            }
            catch (Throwable e) {
                if (e instanceof ExecutionListener.AbortExecutionException) {
                    throw (ExecutionListener.AbortExecutionException)e;
                }
                logger.error("Error invoking listener " + listener, e);
            }
        }
    }

    public void onStartWithServer(ExecutionInfo info) {
        this.onStartWithServer(this.context, info);
    }

    public void onStartWithServer(ExecutionContext<I> context, ExecutionInfo info) {
        for (ExecutionListener<I, O> listener : this.listeners) {
            try {
                listener.onStartWithServer(context.getChildContext(listener), info);
            }
            catch (Throwable e) {
                if (e instanceof ExecutionListener.AbortExecutionException) {
                    throw (ExecutionListener.AbortExecutionException)e;
                }
                logger.error("Error invoking listener " + listener, e);
            }
        }
    }

    public void onExceptionWithServer(Throwable exception, ExecutionInfo info) {
        this.onExceptionWithServer(this.context, exception, info);
    }

    public void onExceptionWithServer(ExecutionContext<I> context, Throwable exception, ExecutionInfo info) {
        for (ExecutionListener<I, O> listener : this.listeners) {
            try {
                listener.onExceptionWithServer(context.getChildContext(listener), exception, info);
            }
            catch (Throwable e) {
                logger.error("Error invoking listener " + listener, e);
            }
        }
    }

    public void onExecutionSuccess(O response, ExecutionInfo info) {
        this.onExecutionSuccess(this.context, response, info);
    }

    public void onExecutionSuccess(ExecutionContext<I> context, O response, ExecutionInfo info) {
        for (ExecutionListener<I, O> listener : this.listeners) {
            try {
                listener.onExecutionSuccess(context.getChildContext(listener), response, info);
            }
            catch (Throwable e) {
                logger.error("Error invoking listener " + listener, e);
            }
        }
    }

    public void onExecutionFailed(Throwable finalException, ExecutionInfo info) {
        this.onExecutionFailed(this.context, finalException, info);
    }

    public void onExecutionFailed(ExecutionContext<I> context, Throwable finalException, ExecutionInfo info) {
        for (ExecutionListener<I, O> listener : this.listeners) {
            try {
                listener.onExecutionFailed(context.getChildContext(listener), finalException, info);
            }
            catch (Throwable e) {
                logger.error("Error invoking listener " + listener, e);
            }
        }
    }
}

