/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.loadbalancer;

import com.netflix.client.ClientFactory;
import com.netflix.client.config.ClientConfigFactory;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.client.config.IClientConfigKey;
import com.netflix.loadbalancer.BaseLoadBalancer;
import com.netflix.loadbalancer.DummyPing;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.IPing;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerList;
import com.netflix.loadbalancer.ServerListFilter;
import com.netflix.loadbalancer.ServerListUpdater;
import com.netflix.loadbalancer.ZoneAwareLoadBalancer;
import java.util.List;

public class LoadBalancerBuilder<T extends Server> {
    private IClientConfig config = ClientConfigFactory.findDefaultConfigFactory().newConfig();
    private ServerListFilter serverListFilter;
    private IRule rule;
    private IPing ping = new DummyPing();
    private ServerList serverListImpl;
    private ServerListUpdater serverListUpdater;

    private LoadBalancerBuilder() {
    }

    public static <T extends Server> LoadBalancerBuilder<T> newBuilder() {
        return new LoadBalancerBuilder<T>();
    }

    public LoadBalancerBuilder<T> withClientConfig(IClientConfig config) {
        this.config = config;
        return this;
    }

    public LoadBalancerBuilder<T> withRule(IRule rule) {
        this.rule = rule;
        return this;
    }

    public LoadBalancerBuilder<T> withPing(IPing ping) {
        this.ping = ping;
        return this;
    }

    public LoadBalancerBuilder<T> withDynamicServerList(ServerList<T> serverListImpl) {
        this.serverListImpl = serverListImpl;
        return this;
    }

    public LoadBalancerBuilder<T> withServerListFilter(ServerListFilter<T> serverListFilter) {
        this.serverListFilter = serverListFilter;
        return this;
    }

    public LoadBalancerBuilder<T> withServerListUpdater(ServerListUpdater serverListUpdater) {
        this.serverListUpdater = serverListUpdater;
        return this;
    }

    public BaseLoadBalancer buildFixedServerListLoadBalancer(List<T> servers) {
        if (this.rule == null) {
            this.rule = LoadBalancerBuilder.createRuleFromConfig(this.config);
        }
        BaseLoadBalancer lb = new BaseLoadBalancer(this.config, this.rule, this.ping);
        lb.setServersList(servers);
        return lb;
    }

    private static IRule createRuleFromConfig(IClientConfig config) {
        IRule rule;
        String ruleClassName = (String)config.getOrDefault(IClientConfigKey.Keys.NFLoadBalancerRuleClassName);
        if (ruleClassName == null) {
            throw new IllegalArgumentException("NFLoadBalancerRuleClassName is not specified in the config");
        }
        try {
            rule = (IRule)ClientFactory.instantiateInstanceWithClientConfig(ruleClassName, config);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return rule;
    }

    private static ServerListUpdater createServerListUpdaterFromConfig(IClientConfig config) {
        ServerListUpdater updater;
        String serverListUpdaterClassName = (String)config.getOrDefault(IClientConfigKey.Keys.ServerListUpdaterClassName);
        if (serverListUpdaterClassName == null) {
            throw new IllegalArgumentException("NIWSServerListClassName is not specified in the config");
        }
        try {
            updater = (ServerListUpdater)ClientFactory.instantiateInstanceWithClientConfig(serverListUpdaterClassName, config);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return updater;
    }

    private static ServerList<Server> createServerListFromConfig(IClientConfig config) {
        ServerList list;
        String serverListClassName = (String)config.get(IClientConfigKey.Keys.NIWSServerListClassName);
        if (serverListClassName == null) {
            throw new IllegalArgumentException("NIWSServerListClassName is not specified in the config");
        }
        try {
            list = (ServerList)ClientFactory.instantiateInstanceWithClientConfig(serverListClassName, config);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return list;
    }

    public ZoneAwareLoadBalancer<T> buildDynamicServerListLoadBalancer() {
        if (this.serverListImpl == null) {
            this.serverListImpl = LoadBalancerBuilder.createServerListFromConfig(this.config);
        }
        if (this.rule == null) {
            this.rule = LoadBalancerBuilder.createRuleFromConfig(this.config);
        }
        return new ZoneAwareLoadBalancer(this.config, this.rule, this.ping, this.serverListImpl, this.serverListFilter);
    }

    public ZoneAwareLoadBalancer<T> buildDynamicServerListLoadBalancerWithUpdater() {
        if (this.serverListImpl == null) {
            this.serverListImpl = LoadBalancerBuilder.createServerListFromConfig(this.config);
        }
        if (this.rule == null) {
            this.rule = LoadBalancerBuilder.createRuleFromConfig(this.config);
        }
        if (this.serverListUpdater == null) {
            this.serverListUpdater = LoadBalancerBuilder.createServerListUpdaterFromConfig(this.config);
        }
        return new ZoneAwareLoadBalancer(this.config, this.rule, this.ping, this.serverListImpl, this.serverListFilter, this.serverListUpdater);
    }

    public ILoadBalancer buildLoadBalancerFromConfigWithReflection() {
        ILoadBalancer lb;
        String loadBalancerClassName = (String)this.config.get(CommonClientConfigKey.NFLoadBalancerClassName);
        if (loadBalancerClassName == null) {
            throw new IllegalArgumentException("NFLoadBalancerClassName is not specified in the IClientConfig");
        }
        try {
            lb = (ILoadBalancer)ClientFactory.instantiateInstanceWithClientConfig(loadBalancerClassName, this.config);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return lb;
    }
}

