/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.ipc;

import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.api.Utils;
import com.netflix.spectator.ipc.IpcAttempt;
import com.netflix.spectator.ipc.IpcErrorGroup;
import com.netflix.spectator.ipc.IpcResult;
import com.netflix.spectator.ipc.IpcTagKey;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;

public enum IpcMetric {
    clientCall("ipc.client.call", EnumSet.of(IpcTagKey.owner, IpcTagKey.result, IpcTagKey.attempt, IpcTagKey.attemptFinal, IpcTagKey.errorGroup)),
    serverCall("ipc.server.call", EnumSet.of(IpcTagKey.owner, IpcTagKey.result, IpcTagKey.errorGroup)),
    clientInflight("ipc.client.inflight", EnumSet.of(IpcTagKey.owner)),
    serverInflight("ipc.server.inflight", EnumSet.of(IpcTagKey.owner));

    private final String metricName;
    private final EnumSet<IpcTagKey> requiredDimensions;
    private static final Class<?>[] METER_TYPES;
    private static final SortedSet<String> ATTEMPT_FINAL_VALUES;

    private IpcMetric(String metricName, EnumSet<IpcTagKey> requiredDimensions) {
        this.metricName = metricName;
        this.requiredDimensions = requiredDimensions;
    }

    public String metricName() {
        return this.metricName;
    }

    public EnumSet<IpcTagKey> requiredDimensions() {
        return this.requiredDimensions;
    }

    private static void assertTrue(boolean condition, String description, Object ... args) {
        if (!condition) {
            throw new IllegalArgumentException(String.format(description, args));
        }
    }

    private static String getName(Class<?> cls) {
        for (Class<?> c : METER_TYPES) {
            if (!c.isAssignableFrom(cls)) continue;
            return c.getSimpleName();
        }
        return cls.getSimpleName();
    }

    private static void validateIpcMeter(Registry registry, IpcMetric metric, Class<?> type) {
        String name = metric.metricName();
        registry.stream().filter(m -> name.equals(m.id().name())).forEach(m -> {
            IpcMetric.assertTrue(type.isAssignableFrom(m.getClass()), "[%s] has the wrong type, expected %s but found %s", m.id(), type.getSimpleName(), IpcMetric.getName(m.getClass()));
            metric.validate(m.id());
        });
    }

    public static void validate(Registry registry) {
        IpcMetric.validateIpcMeter(registry, clientCall, Timer.class);
        IpcMetric.validateIpcMeter(registry, serverCall, Timer.class);
        IpcMetric.validateIpcMeter(registry, clientInflight, DistributionSummary.class);
        IpcMetric.validateIpcMeter(registry, serverInflight, DistributionSummary.class);
    }

    private <T extends Enum<T>> void validateValues(Id id, String key, Class<T> cls) {
        String value = Utils.getTagValue((Id)id, (String)key);
        if (value != null) {
            try {
                Enum.valueOf(cls, value);
            }
            catch (Exception e) {
                String values = Arrays.stream(cls.getEnumConstants()).map(Enum::name).collect(Collectors.joining(", "));
                throw new IllegalArgumentException(String.format("[%s] invalid value for dimension %s, acceptable values are (%s)", id, key, values));
            }
        }
    }

    private void validateValues(Id id, String key, SortedSet<String> allowedValues) {
        String value = Utils.getTagValue((Id)id, (String)key);
        if (value != null && !allowedValues.contains(value)) {
            String values = allowedValues.stream().collect(Collectors.joining(", "));
            throw new IllegalArgumentException(String.format("[%s] invalid value for dimension %s, acceptable values are (%s)", id, key, values));
        }
    }

    public void validate(Id id) {
        IpcMetric.assertTrue(this.metricName.equals(id.name()), "%s != %s", this.metricName, id.name());
        Object dimensions = this.requiredDimensions.clone();
        ((AbstractCollection)dimensions).remove((Object)IpcTagKey.errorGroup);
        dimensions.forEach(k -> {
            String value = Utils.getTagValue((Id)id, (String)k.key());
            IpcMetric.assertTrue(value != null, "[%s] is missing required dimension %s", id, k.key());
        });
        if (this.requiredDimensions.contains((Object)IpcTagKey.errorGroup)) {
            String result = Utils.getTagValue((Id)id, (String)IpcTagKey.result.key());
            String errorGroup = Utils.getTagValue((Id)id, (String)IpcTagKey.errorGroup.key());
            switch (result) {
                case "success": {
                    IpcMetric.assertTrue(errorGroup == null, "[%s] %s should not be present on successful request", id, IpcTagKey.errorGroup.key());
                    break;
                }
                case "failure": {
                    IpcMetric.assertTrue(errorGroup != null, "[%s] %s must be present on failed request", id, IpcTagKey.errorGroup.key());
                    break;
                }
            }
        }
        this.validateValues(id, IpcTagKey.attemptFinal.key(), ATTEMPT_FINAL_VALUES);
        this.validateValues(id, IpcTagKey.attempt.key(), IpcAttempt.class);
        this.validateValues(id, IpcTagKey.result.key(), IpcResult.class);
        this.validateValues(id, IpcTagKey.errorGroup.key(), IpcErrorGroup.class);
    }

    static {
        METER_TYPES = new Class[]{Counter.class, Timer.class, DistributionSummary.class, Gauge.class};
        ATTEMPT_FINAL_VALUES = new TreeSet<String>();
        ATTEMPT_FINAL_VALUES.add(Boolean.TRUE.toString());
        ATTEMPT_FINAL_VALUES.add(Boolean.FALSE.toString());
    }
}

