/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.jvm;

import com.netflix.spectator.jvm.JmxMeasurementConfig;
import com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;

final class JmxConfig {
    private final ObjectName query;
    private final List<JmxMeasurementConfig> measurements;

    static JmxConfig from(Config config) {
        try {
            ObjectName query = new ObjectName(config.getString("query"));
            ArrayList<JmxMeasurementConfig> ms = new ArrayList<JmxMeasurementConfig>();
            for (Config cfg : config.getConfigList("measurements")) {
                ms.add(JmxMeasurementConfig.from(cfg));
            }
            return new JmxConfig(query, ms);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid mapping config", e);
        }
    }

    JmxConfig(ObjectName query, List<JmxMeasurementConfig> measurements) {
        this.query = query;
        this.measurements = measurements;
    }

    ObjectName getQuery() {
        return this.query;
    }

    List<JmxMeasurementConfig> getMeasurements() {
        return this.measurements;
    }
}

