/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul;

import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.zuul.ExecutionStatus;
import com.netflix.zuul.IZuulFilter;
import com.netflix.zuul.ZuulFilterResult;
import com.netflix.zuul.monitoring.Tracer;
import com.netflix.zuul.monitoring.TracerFactory;
import java.util.ArrayList;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public abstract class ZuulFilter
implements IZuulFilter,
Comparable<ZuulFilter> {
    private final DynamicBooleanProperty filterDisabled = DynamicPropertyFactory.getInstance().getBooleanProperty(this.disablePropertyName(), false);

    public abstract String filterType();

    public abstract int filterOrder();

    public boolean isStaticFilter() {
        return true;
    }

    public String disablePropertyName() {
        return "zuul." + this.getClass().getSimpleName() + "." + this.filterType() + ".disable";
    }

    public boolean isFilterDisabled() {
        return this.filterDisabled.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZuulFilterResult runFilter() {
        ZuulFilterResult zr = new ZuulFilterResult();
        if (!this.filterDisabled.get()) {
            if (this.shouldFilter()) {
                Tracer t = TracerFactory.instance().startMicroTracer("ZUUL::" + this.getClass().getSimpleName());
                try {
                    Object res = this.run();
                    zr = new ZuulFilterResult(res, ExecutionStatus.SUCCESS);
                }
                catch (Throwable e) {
                    t.setName("ZUUL::" + this.getClass().getSimpleName() + " failed");
                    zr = new ZuulFilterResult(ExecutionStatus.FAILED);
                    zr.setException(e);
                }
                finally {
                    t.stopAndLog();
                }
            } else {
                zr = new ZuulFilterResult(ExecutionStatus.SKIPPED);
            }
        }
        return zr;
    }

    @Override
    public int compareTo(ZuulFilter filter) {
        return this.filterOrder() - filter.filterOrder();
    }

    public static class TestUnit {
        @Mock
        private ZuulFilter f1;
        @Mock
        private ZuulFilter f2;

        @Before
        public void before() {
            MockitoAnnotations.initMocks((Object)this);
        }

        @Test
        public void testSort() {
            Mockito.when((Object)this.f1.filterOrder()).thenReturn((Object)1);
            Mockito.when((Object)this.f2.filterOrder()).thenReturn((Object)10);
            Mockito.when((Object)this.f1.compareTo((ZuulFilter)Mockito.any(ZuulFilter.class))).thenCallRealMethod();
            Mockito.when((Object)this.f2.compareTo((ZuulFilter)Mockito.any(ZuulFilter.class))).thenCallRealMethod();
            ArrayList<ZuulFilter> list = new ArrayList<ZuulFilter>();
            list.add(this.f2);
            list.add(this.f1);
            Collections.sort(list);
            Assert.assertSame((Object)this.f1, list.get(0));
        }

        @Test
        public void testShouldFilter() {
            class TestZuulFilter
            extends ZuulFilter {
                TestZuulFilter() {
                }

                @Override
                public String filterType() {
                    return null;
                }

                @Override
                public int filterOrder() {
                    return 0;
                }

                @Override
                public boolean shouldFilter() {
                    return false;
                }

                @Override
                public Object run() {
                    return null;
                }
            }
            TestZuulFilter tf1 = (TestZuulFilter)Mockito.spy((Object)new TestZuulFilter());
            TestZuulFilter tf2 = (TestZuulFilter)Mockito.spy((Object)new TestZuulFilter());
            Mockito.when((Object)tf1.shouldFilter()).thenReturn((Object)true);
            Mockito.when((Object)tf2.shouldFilter()).thenReturn((Object)false);
            try {
                tf1.runFilter();
                tf2.runFilter();
                ((TestZuulFilter)Mockito.verify((Object)tf1, (VerificationMode)Mockito.times((int)1))).run();
                ((TestZuulFilter)Mockito.verify((Object)tf2, (VerificationMode)Mockito.times((int)0))).run();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }
}

