/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul;

import com.netflix.zuul.FilterLoader;
import com.netflix.zuul.groovy.GroovyFileFilter;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class FilterFileManager {
    private static final Logger LOG = LoggerFactory.getLogger(FilterFileManager.class);
    Thread poller;
    boolean bRunning = true;
    @Inject
    private FilterFileManagerConfig config;
    @Inject
    private FilterLoader filterLoader;

    @PostConstruct
    public void init() throws Exception {
        this.filterLoader.putFiltersForClasses(this.config.getClassNames());
        this.manageFiles();
        this.startPoller();
    }

    @PreDestroy
    public void shutdown() {
        this.stopPoller();
    }

    void stopPoller() {
        this.bRunning = false;
    }

    void startPoller() {
        this.poller = new Thread("GroovyFilterFileManagerPoller"){

            @Override
            public void run() {
                while (FilterFileManager.this.bRunning) {
                    try {
                        1.sleep(FilterFileManager.this.config.getPollingIntervalSeconds() * 1000);
                        FilterFileManager.this.manageFiles();
                    }
                    catch (Exception e) {
                        LOG.error("Error checking and/or loading filter files from Poller thread.", (Throwable)e);
                    }
                }
            }
        };
        this.poller.start();
    }

    public File getDirectory(String sPath) {
        File directory = new File(sPath);
        if (!directory.isDirectory()) {
            URL resource = FilterFileManager.class.getClassLoader().getResource(sPath);
            try {
                directory = new File(resource.toURI());
            }
            catch (Exception e) {
                LOG.error("Error accessing directory in classloader. path=" + sPath, (Throwable)e);
            }
            if (!directory.isDirectory()) {
                throw new RuntimeException(directory.getAbsolutePath() + " is not a valid directory");
            }
        }
        return directory;
    }

    List<File> getFiles() {
        ArrayList<File> list = new ArrayList<File>();
        for (String sDirectory : this.config.getDirectories()) {
            File directory;
            File[] aFiles;
            if (sDirectory == null || (aFiles = (directory = this.getDirectory(sDirectory)).listFiles(this.config.getFilenameFilter())) == null) continue;
            list.addAll(Arrays.asList(aFiles));
        }
        return list;
    }

    void processGroovyFiles(List<File> aFiles) throws Exception {
        for (File file : aFiles) {
            this.filterLoader.putFilter(file);
        }
    }

    void manageFiles() {
        try {
            List<File> aFiles = this.getFiles();
            this.processGroovyFiles(aFiles);
        }
        catch (Exception e) {
            String msg = "Error updating groovy filters from disk!";
            LOG.error(msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
    }

    @RunWith(value=MockitoJUnitRunner.class)
    public static class UnitTest {
        @Mock
        private File nonGroovyFile;
        @Mock
        private File groovyFile;
        @Mock
        private File directory;
        @Mock
        private FilterLoader filterLoader;

        @Before
        public void before() {
            MockitoAnnotations.initMocks((Object)this);
        }

        @Test
        public void testFileManagerInit() throws Exception {
            FilterFileManagerConfig config = new FilterFileManagerConfig(new String[]{"test", "test1"}, new String[]{"com.netflix.blah.SomeFilter"}, 1);
            FilterFileManager manager = new FilterFileManager();
            manager.config = config;
            manager.filterLoader = this.filterLoader;
            manager = (FilterFileManager)Mockito.spy((Object)manager);
            ((FilterFileManager)Mockito.doNothing().when((Object)manager)).manageFiles();
            manager.init();
            ((FilterFileManager)Mockito.verify((Object)manager, (VerificationMode)Mockito.atLeast((int)1))).manageFiles();
            ((FilterFileManager)Mockito.verify((Object)manager, (VerificationMode)Mockito.times((int)1))).startPoller();
            Assert.assertNotNull((Object)manager.poller);
        }
    }

    public static class FilterFileManagerConfig {
        private String[] directories;
        private String[] classNames;
        private int pollingIntervalSeconds;
        private FilenameFilter filenameFilter;

        public FilterFileManagerConfig(String[] directories, String[] classNames, int pollingIntervalSeconds, FilenameFilter filenameFilter) {
            this.directories = directories;
            this.classNames = classNames;
            this.pollingIntervalSeconds = pollingIntervalSeconds;
            this.filenameFilter = filenameFilter;
        }

        public FilterFileManagerConfig(String[] directories, String[] classNames, int pollingIntervalSeconds) {
            this(directories, classNames, pollingIntervalSeconds, new GroovyFileFilter());
        }

        public String[] getDirectories() {
            return this.directories;
        }

        public String[] getClassNames() {
            return this.classNames;
        }

        public int getPollingIntervalSeconds() {
            return this.pollingIntervalSeconds;
        }

        public FilenameFilter getFilenameFilter() {
            return this.filenameFilter;
        }
    }
}

