/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul;

import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import com.netflix.servo.monitor.DynamicCounter;
import com.netflix.zuul.ExecutionStatus;
import com.netflix.zuul.FilterLoader;
import com.netflix.zuul.FilterUsageNotifier;
import com.netflix.zuul.context.Debug;
import com.netflix.zuul.context.Headers;
import com.netflix.zuul.context.HttpQueryParams;
import com.netflix.zuul.context.HttpRequestMessage;
import com.netflix.zuul.context.HttpResponseMessage;
import com.netflix.zuul.context.SessionContext;
import com.netflix.zuul.context.ZuulMessage;
import com.netflix.zuul.exception.ZuulException;
import com.netflix.zuul.filters.BaseSyncFilter;
import com.netflix.zuul.filters.FilterError;
import com.netflix.zuul.filters.FilterPriority;
import com.netflix.zuul.filters.ShouldFilter;
import com.netflix.zuul.filters.ZuulFilter;
import com.netflix.zuul.monitoring.MonitoringHelper;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.functions.Func1;

@Singleton
public class FilterProcessor {
    protected static final Logger LOG = LoggerFactory.getLogger(FilterProcessor.class);
    protected static final DynamicStringProperty DEFAULT_ERROR_ENDPOINT = DynamicPropertyFactory.getInstance().getStringProperty("zuul.filters.error.default", "endpoint.ErrorResponse");
    @Inject
    private FilterLoader filterLoader;
    @Inject
    @Nullable
    private FilterUsageNotifier usageNotifier;

    public FilterProcessor() {
        if (this.usageNotifier != null) {
            this.usageNotifier = new BasicFilterUsageNotifier();
        }
    }

    public Observable<ZuulMessage> applyInboundFilters(Observable<ZuulMessage> chain) {
        chain = this.applyFilterPhase(chain, "in", (Func1<ZuulMessage, ZuulMessage>)((Func1)request -> request));
        chain = this.applyErrorEndpointIfNeeded(chain);
        return chain;
    }

    public Observable<ZuulMessage> applyErrorEndpointIfNeeded(Observable<ZuulMessage> chain) {
        return chain.flatMap(msg -> {
            SessionContext context = msg.getContext();
            if (context.shouldSendErrorResponse()) {
                ZuulFilter endpointFilter;
                context.setShouldSendErrorResponse(false);
                context.setErrorResponseSent(true);
                String endpointName = context.getErrorEndpoint();
                if (endpointName == null) {
                    endpointName = DEFAULT_ERROR_ENDPOINT.get();
                }
                if ((endpointFilter = this.filterLoader.getFilterByNameAndType(endpointName, "end")) == null) {
                    String errorStr = "No error filter found of chosen name! name=" + endpointName;
                    LOG.error("Errored but no error filter found, so sent default error response. " + errorStr, context.getError());
                    HttpResponseMessage response = new HttpResponseMessage(msg.getContext(), (HttpRequestMessage)msg, 500);
                    response.getHeaders().set("X-Zuul-Error-Cause", errorStr);
                    return Observable.just((Object)response);
                }
                if (HttpResponseMessage.class.isAssignableFrom(msg.getClass())) {
                    HttpResponseMessage response = (HttpResponseMessage)msg;
                    return this.processAsyncFilter(response.getRequest(), endpointFilter, (Func1<ZuulMessage, ZuulMessage>)((Func1)m2 -> m2), FilterPriority.LOW);
                }
                return this.processAsyncFilter((ZuulMessage)msg, endpointFilter, (Func1<ZuulMessage, ZuulMessage>)((Func1)m2 -> m2), FilterPriority.LOW);
            }
            return Observable.just((Object)msg);
        });
    }

    public Observable<ZuulMessage> applyEndpointFilter(Observable<ZuulMessage> chain) {
        chain = chain.flatMap(msg -> {
            SessionContext context = msg.getContext();
            HttpRequestMessage request = (HttpRequestMessage)msg;
            if (context.errorResponseSent()) {
                return Observable.just((Object)msg);
            }
            String endpointName = context.getEndpoint();
            if (endpointName == null) {
                context.setShouldSendErrorResponse(true);
                context.setError(new ZuulException("No endpoint filter chosen!"));
                return Observable.just((Object)new HttpResponseMessage(context, request, 500));
            }
            ZuulFilter endpointFilter = this.filterLoader.getFilterByNameAndType(endpointName, "end");
            if (endpointFilter == null) {
                context.setShouldSendErrorResponse(true);
                context.setError(new ZuulException("No endpoint filter found of chosen name! name=" + endpointName));
                return Observable.just((Object)new HttpResponseMessage(context, request, 500));
            }
            return this.processAsyncFilter((ZuulMessage)msg, endpointFilter, (Func1<ZuulMessage, ZuulMessage>)((Func1)input -> {
                context.setShouldSendErrorResponse(true);
                return input;
            }), FilterPriority.LOW);
        });
        chain = this.applyErrorEndpointIfNeeded(chain);
        return chain;
    }

    public Observable<ZuulMessage> applyOutboundFilters(Observable<ZuulMessage> chain) {
        chain = this.applyFilterPhase(chain, "out", (Func1<ZuulMessage, ZuulMessage>)((Func1)response -> response));
        chain = this.applyErrorEndpointIfNeeded(chain);
        return chain;
    }

    protected Observable<ZuulMessage> applyFilterPhase(Observable<ZuulMessage> chain, String filterType, Func1<ZuulMessage, ZuulMessage> defaultFilterResultChooser) {
        List<ZuulFilter> filters = this.filterLoader.getFiltersByType(filterType);
        for (ZuulFilter filter : filters) {
            chain = this.processFilterAsObservable(chain, filter, defaultFilterResultChooser).single();
        }
        return chain;
    }

    public Observable<ZuulMessage> processFilterAsObservable(Observable<ZuulMessage> input, ZuulFilter filter, Func1<ZuulMessage, ZuulMessage> defaultFilterResultChooser) {
        return input.flatMap(msg -> this.processAsyncFilter((ZuulMessage)msg, filter, defaultFilterResultChooser));
    }

    public Observable<ZuulMessage> processAsyncFilter(ZuulMessage msg, ZuulFilter filter, Func1<ZuulMessage, ZuulMessage> defaultFilterResultChooser) {
        return this.processAsyncFilter(msg, filter, defaultFilterResultChooser, null);
    }

    public Observable<ZuulMessage> processAsyncFilter(ZuulMessage msg, ZuulFilter filter, Func1<ZuulMessage, ZuulMessage> defaultFilterResultChooser, FilterPriority overrideFilterPriority) {
        Observable resultObs;
        FilterExecInfo info = new FilterExecInfo();
        info.bDebug = msg.getContext().debugRouting();
        if (info.bDebug) {
            Debug.addRoutingDebug(msg.getContext(), "Filter " + filter.filterType() + " " + filter.filterOrder() + " " + filter.filterName());
            info.debugCopy = msg.clone();
        }
        long ltime = System.currentTimeMillis();
        try {
            if (filter.isDisabled()) {
                resultObs = Observable.just((Object)defaultFilterResultChooser.call((Object)msg));
                info.status = ExecutionStatus.DISABLED;
            } else {
                FilterPriority requiredPriority;
                FilterPriority filterPriority = requiredPriority = overrideFilterPriority == null ? msg.getContext().getFilterPriorityToApply() : overrideFilterPriority;
                if (this.isFilterPriority(filter, requiredPriority) && filter.shouldFilter(msg)) {
                    resultObs = filter.applyAsync(msg).single();
                } else {
                    resultObs = Observable.just((Object)defaultFilterResultChooser.call((Object)msg));
                    info.status = ExecutionStatus.SKIPPED;
                }
            }
        }
        catch (Exception e2) {
            msg.getContext().setError(e2);
            resultObs = Observable.just((Object)defaultFilterResultChooser.call((Object)msg));
            info.status = ExecutionStatus.FAILED;
            this.recordFilterError(filter, msg, e2);
        }
        resultObs = resultObs.onErrorReturn(e -> {
            msg.getContext().setError((Throwable)e);
            filterExecInfo.status = ExecutionStatus.FAILED;
            this.recordFilterError(filter, msg, (Throwable)e);
            return (ZuulMessage)defaultFilterResultChooser.call((Object)msg);
        });
        resultObs = resultObs.map(msg2 -> msg2 == null ? (ZuulMessage)defaultFilterResultChooser.call((Object)msg) : msg2);
        resultObs = resultObs.doOnCompleted(() -> {
            if (filterExecInfo.status == null) {
                filterExecInfo.status = ExecutionStatus.SUCCESS;
            }
            filterExecInfo.execTime = System.currentTimeMillis() - ltime;
            this.recordFilterCompletion(msg, filter, info);
        });
        return resultObs;
    }

    private boolean isFilterPriority(ZuulFilter filter, FilterPriority requiredPriority) {
        return filter.getPriority().getCode() >= requiredPriority.getCode();
    }

    protected void recordFilterCompletion(ZuulMessage msg, ZuulFilter filter, FilterExecInfo info) {
        switch (info.status) {
            case FAILED: {
                msg.getContext().addFilterExecutionSummary(filter.filterName(), ExecutionStatus.FAILED.name(), info.execTime);
                break;
            }
            case SUCCESS: {
                msg.getContext().addFilterExecutionSummary(filter.filterName(), ExecutionStatus.SUCCESS.name(), info.execTime);
                if (!info.bDebug) break;
                Debug.addRoutingDebug(msg.getContext(), "Filter {" + filter.filterName() + " TYPE:" + filter.filterType() + " ORDER:" + filter.filterOrder() + "} Execution time = " + info.execTime + "ms");
                Debug.compareContextState(filter.filterName(), msg.getContext(), info.debugCopy.getContext());
                break;
            }
        }
        this.usageNotifier.notify(filter, info.status);
    }

    protected void recordFilterError(ZuulFilter filter, ZuulMessage msg, Throwable e) {
        String errorMsg = "Filter Exception: filter=" + String.valueOf(filter) + ", request-info=" + msg.getInfoForLogging() + ", msg=" + String.valueOf(e.getMessage());
        if (e instanceof ZuulException && !((ZuulException)e).shouldLogAsError()) {
            LOG.warn(errorMsg);
        } else {
            LOG.error(errorMsg, e);
        }
        msg.getContext().getFilterErrors().add(new FilterError(filter.filterName(), filter.filterType(), e));
        boolean bDebug = msg.getContext().debugRouting();
        if (bDebug) {
            Debug.addRoutingDebug(msg.getContext(), "Running Filter failed " + filter.filterName() + " type:" + filter.filterType() + " order:" + filter.filterOrder() + " " + e.getMessage());
        }
    }

    @RunWith(value=MockitoJUnitRunner.class)
    public static class UnitTest {
        @Mock
        BaseSyncFilter filter;
        @Mock
        ShouldFilter additionalShouldFilter;
        SessionContext ctx;
        HttpRequestMessage request;
        HttpResponseMessage response;
        FilterProcessor processor;

        @Before
        public void before() {
            MonitoringHelper.initMocks();
            MockitoAnnotations.initMocks((Object)this);
            this.ctx = new SessionContext();
            this.request = new HttpRequestMessage(this.ctx, "HTTP/1.1", "GET", "/somepath", new HttpQueryParams(), new Headers(), "127.0.0.1", "https", 80, "localhost");
            this.response = new HttpResponseMessage(this.ctx, this.request, 200);
            this.processor = new FilterProcessor();
            this.processor = (FilterProcessor)Mockito.spy((Object)this.processor);
            Mockito.when((Object)this.filter.filterType()).thenReturn((Object)"pre");
            Mockito.when((Object)this.filter.shouldFilter(this.request)).thenReturn((Object)true);
            Mockito.when((Object)((Object)this.filter.getPriority())).thenReturn((Object)FilterPriority.NORMAL);
        }

        @Test
        public void testProcessFilter() throws Exception {
            Mockito.when(this.filter.applyAsync(this.request)).thenReturn((Object)Observable.just((Object)this.request));
            this.processor.processAsyncFilter(this.request, this.filter, (Func1<ZuulMessage, ZuulMessage>)((Func1)m -> m)).toBlocking().first();
            ((BaseSyncFilter)Mockito.verify((Object)this.filter, (VerificationMode)Mockito.times((int)1))).applyAsync(this.request);
        }

        @Test
        public void testProcessFilter_ShouldFilterFalse() throws Exception {
            Mockito.when((Object)this.filter.shouldFilter(this.request)).thenReturn((Object)false);
            this.processor.processAsyncFilter(this.request, this.filter, (Func1<ZuulMessage, ZuulMessage>)((Func1)m -> m)).toBlocking().first();
            ((BaseSyncFilter)Mockito.verify((Object)this.filter, (VerificationMode)Mockito.times((int)0))).applyAsync(this.request);
        }

        @Test
        public void testProcessFilterException() {
            RuntimeException e = new RuntimeException("Blah");
            Mockito.when(this.filter.applyAsync(this.request)).thenThrow(new Throwable[]{e});
            this.processor.processAsyncFilter(this.request, this.filter, (Func1<ZuulMessage, ZuulMessage>)((Func1)m -> m)).toBlocking().first();
            ((FilterProcessor)Mockito.verify((Object)this.processor)).recordFilterError(this.filter, this.request, e);
            ArgumentCaptor info = ArgumentCaptor.forClass(FilterExecInfo.class);
            ((FilterProcessor)Mockito.verify((Object)this.processor)).recordFilterCompletion((ZuulMessage)Mockito.same((Object)this.request), (ZuulFilter)Mockito.same((Object)this.filter), (FilterExecInfo)info.capture());
            Assert.assertEquals((Object)((Object)ExecutionStatus.FAILED), (Object)((Object)((FilterExecInfo)info.getValue()).status));
        }
    }

    static class FilterExecInfo {
        ExecutionStatus status;
        boolean bDebug = false;
        long execTime;
        ZuulMessage debugCopy = null;

        FilterExecInfo() {
        }
    }

    public static class BasicFilterUsageNotifier
    implements FilterUsageNotifier {
        private static final String METRIC_PREFIX = "zuul.filter-";

        @Override
        public void notify(ZuulFilter filter, ExecutionStatus status) {
            DynamicCounter.increment((String)(METRIC_PREFIX + filter.getClass().getSimpleName()), (String[])new String[]{"status", status.name(), "filtertype", filter.filterType()});
        }
    }
}

