/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.bytebuf;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import rx.Observable;
import rx.observables.StringObservable;

public class ByteBufUtils {
    public static byte[] toBytes(ByteBuf bb) {
        try {
            int size = bb.readableBytes();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            bb.getBytes(0, (OutputStream)baos, size);
            return baos.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException("Error buffering message body!", e);
        }
    }

    public static Observable<ByteBuf> aggregate(Observable<ByteBuf> source, int maxBodySize) {
        return source.reduce((bb1, bb2) -> {
            if (bb1.readableBytes() > maxBodySize) {
                throw new RuntimeException("Max message body size exceeded! maxBodySize=" + maxBodySize);
            }
            return Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{bb1, bb2});
        });
    }

    public static Observable<ByteBuf> fromInputStream(InputStream input) {
        return StringObservable.from((InputStream)input).map(bytes -> Unpooled.wrappedBuffer((byte[])bytes)).defaultIfEmpty((Object)Unpooled.buffer());
    }
}

