/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.context;

import com.netflix.zuul.context.SessionContext;
import com.netflix.zuul.context.ZuulMessage;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Debug {
    private static final Logger LOG = LoggerFactory.getLogger(Debug.class);

    public static void setDebugRequest(SessionContext ctx, boolean bDebug) {
        ctx.setDebugRequest(bDebug);
    }

    public static void setDebugRequestHeadersOnly(SessionContext ctx, boolean bHeadersOnly) {
        ctx.setDebugRequestHeadersOnly(bHeadersOnly);
    }

    public static boolean debugRequestHeadersOnly(SessionContext ctx) {
        return ctx.debugRequestHeadersOnly();
    }

    public static void setDebugRouting(SessionContext ctx, boolean bDebug) {
        ctx.setDebugRouting(bDebug);
    }

    public static boolean debugRequest(SessionContext ctx) {
        return ctx.debugRequest();
    }

    public static boolean debugRouting(SessionContext ctx) {
        return ctx.debugRouting();
    }

    public static void addRoutingDebug(SessionContext ctx, String line) {
        List<String> rd = Debug.getRoutingDebug(ctx);
        rd.add(line);
    }

    public static void addRequestDebugForMessage(SessionContext ctx, ZuulMessage message, String prefix) {
        try {
            for (Map.Entry<String, String> header : message.getHeaders().entries()) {
                Debug.addRequestDebug(ctx, prefix + " " + header.getKey() + " " + header.getValue());
            }
            if (message.getBody() != null) {
                String bodyStr = new String(message.getBody(), "UTF-8");
                Debug.addRequestDebug(ctx, prefix + " " + bodyStr);
            }
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn("Error writing message to debug log.", (Throwable)e);
        }
    }

    public static List<String> getRoutingDebug(SessionContext ctx) {
        ArrayList rd = (ArrayList)ctx.get("routingDebug");
        if (rd == null) {
            rd = new ArrayList();
            ctx.set("routingDebug", rd);
        }
        return rd;
    }

    public static void addRequestDebug(SessionContext ctx, String line) {
        List<String> rd = Debug.getRequestDebug(ctx);
        rd.add(line);
    }

    public static List<String> getRequestDebug(SessionContext ctx) {
        ArrayList rd = (ArrayList)ctx.get("requestDebug");
        if (rd == null) {
            rd = new ArrayList();
            ctx.set("requestDebug", rd);
        }
        return rd;
    }

    public static void compareContextState(String filterName, SessionContext context, SessionContext copy) {
        Iterator it = context.keySet().iterator();
        String key = (String)it.next();
        while (key != null) {
            if (!key.equals("routingDebug") && !key.equals("requestDebug")) {
                Object newValue = context.get(key);
                Object oldValue = copy.get(key);
                if (oldValue == null && newValue != null) {
                    Debug.addRoutingDebug(context, "{" + filterName + "} added " + key + "=" + newValue.toString());
                } else if (oldValue != null && newValue != null && !oldValue.equals(newValue)) {
                    Debug.addRoutingDebug(context, "{" + filterName + "} changed " + key + "=" + newValue.toString());
                }
            }
            if (it.hasNext()) {
                key = (String)it.next();
                continue;
            }
            key = null;
        }
    }

    @RunWith(value=MockitoJUnitRunner.class)
    public static class UnitTest {
        private SessionContext ctx;

        @Before
        public void setup() {
            this.ctx = new SessionContext();
        }

        @Test
        public void testRequestDebug() {
            Assert.assertFalse((boolean)Debug.debugRouting(this.ctx));
            Assert.assertFalse((boolean)Debug.debugRequest(this.ctx));
            Debug.setDebugRouting(this.ctx, true);
            Debug.setDebugRequest(this.ctx, true);
            Assert.assertTrue((boolean)Debug.debugRouting(this.ctx));
            Assert.assertTrue((boolean)Debug.debugRequest(this.ctx));
            Debug.addRoutingDebug(this.ctx, "test1");
            Assert.assertTrue((boolean)Debug.getRoutingDebug(this.ctx).contains("test1"));
            Debug.addRequestDebug(this.ctx, "test2");
            Assert.assertTrue((boolean)Debug.getRequestDebug(this.ctx).contains("test2"));
        }
    }
}

