/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.context;

import com.google.common.collect.ArrayListMultimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Headers
implements Cloneable {
    private final ArrayListMultimap<String, String> delegate;

    public Headers() {
        this.delegate = ArrayListMultimap.create();
    }

    private Headers(ArrayListMultimap<String, String> delegate) {
        this.delegate = delegate;
    }

    public String getFirst(String name) {
        List values = this.delegate.get((Object)name.toLowerCase());
        if (values != null && values.size() > 0) {
            return (String)values.get(0);
        }
        return null;
    }

    public String getFirst(String name, String defaultValue) {
        String value = this.getFirst(name);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public List<String> get(String name) {
        return this.delegate.get((Object)name.toLowerCase());
    }

    public void set(String name, String value) {
        String lc_name = name.toLowerCase();
        this.delegate.removeAll((Object)lc_name);
        this.delegate.put((Object)lc_name, (Object)value);
    }

    public boolean setIfAbsent(String name, String value) {
        boolean did = false;
        String lc_name = name.toLowerCase();
        if (!this.delegate.containsKey((Object)lc_name)) {
            this.set(lc_name, value);
            did = true;
        }
        return did;
    }

    public void add(String name, String value) {
        this.delegate.put((Object)name.toLowerCase(), (Object)value);
    }

    public void putAll(Headers headers) {
        this.delegate.putAll(headers.delegate);
    }

    public List<String> remove(String name) {
        return this.delegate.removeAll((Object)name.toLowerCase());
    }

    public Collection<Map.Entry<String, String>> entries() {
        return this.delegate.entries();
    }

    public Set<String> keySet() {
        return this.delegate.keySet();
    }

    public boolean contains(String name) {
        return this.delegate.containsKey((Object)name.toLowerCase());
    }

    public boolean contains(String name, String value) {
        return this.delegate.containsEntry((Object)name.toLowerCase(), (Object)value);
    }

    public int size() {
        return this.delegate.size();
    }

    public Headers clone() {
        Headers copy = new Headers();
        copy.delegate.putAll(this.delegate);
        return copy;
    }
}

