/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.context;

import com.google.common.collect.ArrayListMultimap;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import junit.framework.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;

public class HttpQueryParams
implements Cloneable {
    private ArrayListMultimap<String, String> delegate = ArrayListMultimap.create();

    public static HttpQueryParams parse(String queryString) {
        HttpQueryParams queryParams = new HttpQueryParams();
        if (queryString == null) {
            return queryParams;
        }
        StringTokenizer st = new StringTokenizer(queryString, "&");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            int i = s.indexOf("=");
            if (i <= 0 || s.length() <= i + 1) continue;
            String name = s.substring(0, i);
            String value = s.substring(i + 1);
            try {
                name = URLDecoder.decode(name, "UTF-8");
                value = URLDecoder.decode(value, "UTF-8");
            }
            catch (Exception e) {
                // empty catch block
            }
            queryParams.add(name, value);
        }
        return queryParams;
    }

    public String getFirst(String name) {
        List values = this.delegate.get((Object)name);
        if (values != null && values.size() > 0) {
            return (String)values.get(0);
        }
        return null;
    }

    public List<String> get(String name) {
        return this.delegate.get((Object)name.toLowerCase());
    }

    public void set(String name, String value) {
        this.delegate.removeAll((Object)name);
        this.delegate.put((Object)name, (Object)value);
    }

    public void add(String name, String value) {
        this.delegate.put((Object)name, (Object)value);
    }

    public Collection<Map.Entry<String, String>> entries() {
        return this.delegate.entries();
    }

    public Set<String> keySet() {
        return this.delegate.keySet();
    }

    public String toEncodedString() {
        StringBuilder sb = new StringBuilder();
        try {
            for (Map.Entry<String, String> entry : this.entries()) {
                sb.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
                sb.append('=');
                sb.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
                sb.append('&');
            }
            if (sb.length() > 0 && '&' == sb.charAt(sb.length() - 1)) {
                sb.deleteCharAt(sb.length() - 1);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    protected HttpQueryParams clone() {
        HttpQueryParams copy = new HttpQueryParams();
        copy.delegate.putAll(this.delegate);
        return copy;
    }

    @RunWith(value=MockitoJUnitRunner.class)
    public static class TestUnit {
        @Test
        public void testMultiples() {
            HttpQueryParams qp = new HttpQueryParams();
            qp.add("k1", "v1");
            qp.add("k1", "v2");
            qp.add("k2", "v3");
            Assert.assertEquals((String)"k1=v1&k1=v2&k2=v3", (String)qp.toEncodedString());
        }

        @Test
        public void testToEncodedString() {
            HttpQueryParams qp = new HttpQueryParams();
            qp.add("k'1", "v1&");
            Assert.assertEquals((String)"k%271=v1%26", (String)qp.toEncodedString());
            qp = new HttpQueryParams();
            qp.add("k+", "\n");
            Assert.assertEquals((String)"k%2B=%0A", (String)qp.toEncodedString());
        }
    }
}

