/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.context;

import com.netflix.zuul.context.Headers;
import com.netflix.zuul.context.HttpQueryParams;

public class HttpRequestInfo {
    private final String protocol;
    private final String method;
    private final String path;
    private final HttpQueryParams queryParams;
    private final String clientIp;
    private final String scheme;
    private final int port;
    private final Headers headers;

    public HttpRequestInfo(String protocol, String method, String path, HttpQueryParams queryParams, Headers headers, String clientIp, String scheme, int port) {
        this.protocol = protocol;
        this.method = method;
        this.path = path;
        this.queryParams = queryParams == null ? new HttpQueryParams() : queryParams;
        this.headers = headers == null ? new Headers() : headers;
        this.clientIp = clientIp;
        this.scheme = scheme;
        this.port = port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.path;
    }

    public HttpQueryParams getQueryParams() {
        return this.queryParams;
    }

    public String getPathAndQuery() {
        if (this.queryParams != null && this.queryParams.entries().size() > 0) {
            return this.getPath() + "?" + this.queryParams.toEncodedString();
        }
        return this.getPath();
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public String getScheme() {
        return this.scheme;
    }

    public int getPort() {
        return this.port;
    }
}

